/*
 * Copyright (c) 2016, FPX and/or its affiliates. All rights reserved.
 * Use, Copy is subject to authorized license.
 */
package admin.model.response;

import admin.utils.enums.ApiResponseCode;
import lombok.Data;

@Data
public class ApiResponse<T> {
	protected String code;
	protected String message;
	protected T data;
	private String traceId;
	public ApiResponse() {
	}

	public static <T> ApiResponse<T> buildSuccess() {
		ApiResponse<T> response = new ApiResponse();
		response.code = ApiResponseCode.SUCCESS.getCode();
		response.message = ApiResponseCode.SUCCESS.getMessage();
		return response;
	}

	public static <T> ApiResponse<T> buildSuccess(T data) {
		ApiResponse<T> response = new ApiResponse();
		response.data = data;
		response.code = ApiResponseCode.SUCCESS.getCode();
		response.message = ApiResponseCode.SUCCESS.getMessage();
		return response;
	}

	public static <T> ApiResponse<T> buildFailure(ApiResponseCode responseCode) {
		ApiResponse<T> response = new ApiResponse();
		response.code = responseCode.getCode();
		response.message = responseCode.getMessage();
		return response;
	}

	public static <T> ApiResponse<T> buildFailure(String errorCode, String errorMsg) {
		ApiResponse<T> response = new ApiResponse();
		response.code = errorCode;
		response.message = errorMsg;
		return response;
	}
	public static boolean isSuccess(ApiResponse<Object> apiResponse){
		return apiResponse.code.equals("0");
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getCode() {
		return this.code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getMessage() {
		return this.message;
	}

	public ApiResponse<T> setMessage(String message) {
		this.message = message;
		return this;
	}

	public T getData() {
		return this.data;
	}

	public void setData(T data) {
		this.data = data;
	}

	public String toString() {
		return "data.ApiResponse{traceId='" + this.traceId + '\'' + ", code='" + this.code + '\'' + ", message='" + this.message + '\'' + ", data=" + this.data + '}';
	}
}
