package admin.modules.analysis.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
* @author lj
* @date 2024-12-16
*/
@Data
@Builder
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@TableName("api_analysis_info")
public class ApiAnalysisInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(type= IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "日期")
    @NotBlank
    private String timeInterval;

    @ApiModelProperty(value = "接口访问总量")
    private BigDecimal totalCount;

    @ApiModelProperty(value = "成功访问量")
    private BigDecimal sucCount;

    @ApiModelProperty(value = "失败访问量")
    private BigDecimal failCount;

    @ApiModelProperty(value = "接口平均反应时长")
    private BigDecimal avgTime;

    public void copyFrom(ApiAnalysisInfo source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
