package admin.modules.analysis.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @author lj
* @date 2024-12-16
*/
@Data
@Builder
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@TableName("car_analysis_info")
public class CarAnalysisInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(type= IdType.ASSIGN_ID)
    private Long id;

    @ApiModelProperty(value = "流量预测车辆数")
    private BigDecimal carPredictNum;

    @ApiModelProperty(value = "流量预测准确率")
    private String carNum;

    private BigDecimal oneInterval;

    private String timeInterval;

    private BigDecimal twoInterval;

    private BigDecimal threeInterval;

    private BigDecimal fourInterval;

    private BigDecimal fiveInterval;

    private BigDecimal sixInterval;

    private BigDecimal sevenInterval;

    private BigDecimal eightInterval;

    private BigDecimal nineInterval;

    private BigDecimal tenInterval;

    private BigDecimal elevenInterval;

    private BigDecimal twelveInterval;

    public void copyFrom(CarAnalysisInfo source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
