package admin.modules.analysis.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @author lj
* @date 2024-12-16
*/
@Data
@Builder
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@TableName("data_analysis_info")
public class DataAnalysisInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(type= IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "日存储量")
    private BigDecimal dailyStorageCapacity;

    @ApiModelProperty(value = "图片存储量")
    private BigDecimal imgStorageCapacity;

    @ApiModelProperty(value = "总空间")
    private BigDecimal totalSpace;

    @ApiModelProperty(value = "剩余空间")
    private BigDecimal remainingSpace;

    @ApiModelProperty(value = "占用率")
    private String utilizationRatio;

    @ApiModelProperty(value = "日环比")
    private String dailyRingRatio;

    @ApiModelProperty(value = "日期")
    private String timeInterval;

    public void copyFrom(DataAnalysisInfo source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
