package admin.modules.analysis.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
* @author lj
* @date 2024-12-16
*/
@Data
@Builder
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@TableName("device_analysis_info")
public class DeviceAnalysisInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableId(type= IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "时间")
    private String date;

    @ApiModelProperty(value = "总数据量")
    private Long totalCount;

    @ApiModelProperty(value = "清洗数据量")
    private Long clearCount;

    @ApiModelProperty(value = "标准数据量")
    private Long stardCount;

    @ApiModelProperty(value = "每小时平均数据量")
    private Long avgCount;

    public void copyFrom(DeviceAnalysisInfo source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
