package admin.modules.analysis.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
* @author lj
* @date 2024-12-16
*/
@Data
@Builder
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@TableName("msg_analysis_info")
public class MsgAnalysisInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(type= IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "消息主题数")
    private Integer topicCount;

    @ApiModelProperty(value = "入场消息数量")
    private Integer inNum;

    @ApiModelProperty(value = "出场消息数量")
    private Integer outNum;

    @ApiModelProperty(value = "消息消费数")
    private Integer consumeCount;

    @ApiModelProperty(value = "触达率")
    private String reachRate;

    @ApiModelProperty(value = "日期")
    private String timeInterval;

    public void copyFrom(MsgAnalysisInfo source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
