package admin.modules.analysis.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @author lj
* @date 2024-12-16
*/
@Data
@Builder
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@TableName("order_analysis_info")
public class OrderAnalysisInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(type= IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "日期")
    private String timeInterval;

    @ApiModelProperty(value = "云端识别次数")
    private BigDecimal cloudIdentifyNum;

    @ApiModelProperty(value = "云端识别修复次数")
    private BigDecimal cloudIdentifyRepairNum;

    @ApiModelProperty(value = "订单纠正次数")
    private BigDecimal orderRepairNum;

    @ApiModelProperty(value = "提交人工处理次数")
    private BigDecimal submitManualProcessingNum;

    @ApiModelProperty(value = "处理率")
    private String processingRate;

    @ApiModelProperty(value = "日环比")
    private String dailyRingRatio;

    public void copyFrom(OrderAnalysisInfo source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
