package admin.modules.analysis.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @author lj
* @date 2024-12-16
*/
@Data
@Builder
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@TableName("pay_analysis_info")
public class PayAnalysisInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(type= IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "支付消息数")
    private BigDecimal payMsgNum;

    @ApiModelProperty(value = "0-2")
    private BigDecimal oneInterval;

    @ApiModelProperty(value = "日期")
    private String timeInterval;

    @ApiModelProperty(value = "2-4")
    private BigDecimal twoInterval;

    @ApiModelProperty(value = "4-6")
    private BigDecimal threeInterval;

    @ApiModelProperty(value = "6-8")
    private BigDecimal fourInterval;

    @ApiModelProperty(value = "8-10")
    private BigDecimal fiveInterval;

    @ApiModelProperty(value = "10-12")
    private BigDecimal sixInterval;

    @ApiModelProperty(value = "12-14")
    private BigDecimal sevenInterval;

    @ApiModelProperty(value = "14-16")
    private BigDecimal eightInterval;

    @ApiModelProperty(value = "16-18")
    private BigDecimal nineInterval;

    @ApiModelProperty(value = "18-20")
    private BigDecimal tenInterval;

    @ApiModelProperty(value = "20-22")
    private BigDecimal elevenInterval;

    @ApiModelProperty(value = "22-24")
    private BigDecimal twelveInterval;

    public void copyFrom(PayAnalysisInfo source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
