package admin.modules.analysis.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @author lj
* @date 2024-12-16
*/
@Data
@Builder
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@TableName("plate_identify_analysis_info")
public class PlateIdentifyAnalysisInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(type= IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "日期")
    private String timeInterval;

    @ApiModelProperty(value = "车牌识别数")
    private BigDecimal plateIdentifyNum;

    @ApiModelProperty(value = "成功识别数")
    private BigDecimal sucIdentifyNum;

    @ApiModelProperty(value = "失败识别次数")
    private BigDecimal failIdentifyNum;

    @ApiModelProperty(value = "成功率")
    private String sucRatio;

    @ApiModelProperty(value = "日环比")
    private String dailyRingRatio;

    public void copyFrom(PlateIdentifyAnalysisInfo source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
