package admin.modules.analysis.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @author lj
* @date 2024-12-16
*/
@Data
@Builder
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@TableName("push_analysis_info")
public class PushAnalysisInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(type= IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "消息推送数")
    private BigDecimal pushMsgNum;

    @ApiModelProperty(value = "日期")
    private String timeInterval;

    @ApiModelProperty(value = "成功数")
    private BigDecimal sucNum;

    @ApiModelProperty(value = "失败数")
    private BigDecimal failNum;

    @ApiModelProperty(value = "成功率")
    private String sucRatio;

    @ApiModelProperty(value = "日环比")
    private String dailyRingRatio;

    public void copyFrom(PushAnalysisInfo source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
