package admin.modules.analysis.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;

import java.io.Serializable;

/**
* @author lj
* @date 2024-12-18
*/
@Data
@Builder
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@TableName("push_detail_info")
public class PushDetailInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableId(type= IdType.AUTO)
    @Id
    private Long id;

    @ApiModelProperty(value = "1  入场 2-离场 3 付费  4 离场 5  即将产生费用 100 超时补拍通知")
    private Integer msgSubType;

    @ApiModelProperty(value = "1-成功 0-失败")
    private Integer resulte;

    @ApiModelProperty(value = "日期")
    private String date;

    @ApiModelProperty(value = "消息")
    private String content;

    public void copyFrom(PushDetailInfo source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
