package admin.modules.analysis.service;

import admin.base.CommonService;
import admin.base.PageInfo;
import admin.modules.analysis.domain.ApiAnalysisInfo;
import admin.modules.analysis.service.dto.ApiAnalysisInfoDto;
import admin.modules.analysis.service.dto.ApiAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoDto;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
public interface ApiAnalysisInfoService extends CommonService<ApiAnalysisInfo>  {

    static final String CACHE_KEY = "apiAnalysisInfo";

    /**
    * 查询数据分页
    * @param query 条件
    * @param pageable 分页参数
    * @return PageInfo<ApiAnalysisInfoDto>
    */
    PageInfo<ApiAnalysisInfoDto> queryAll(ApiAnalysisInfoQueryCriteria query, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param query 条件参数
    * @return List<ApiAnalysisInfoDto>
    */
    List<ApiAnalysisInfoDto> queryAll(ApiAnalysisInfoQueryCriteria query);

    ApiAnalysisInfo getById(Long id);
    ApiAnalysisInfoDto findById(Long id);

    /**
     * 插入一条新数据。
     */
    int insert(ApiAnalysisInfoDto resources);
    int updateById(ApiAnalysisInfoDto resources);
    int removeById(Long id);
    int removeByIds(Set<Long> ids);

    /**
     * 根据日期查询
     * @param substring
     * @return
     */
    ApiAnalysisInfoDto findByTimeInterval(String date);

    /**
    * 导出数据
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    // void download(List<ApiAnalysisInfoDto> all, HttpServletResponse response) throws IOException;

    PageInfo<ApiAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size);
}
