package admin.modules.analysis.service;

import admin.base.CommonService;
import admin.base.PageInfo;
import admin.modules.analysis.domain.CarAnalysisInfo;
import admin.modules.analysis.service.dto.ApiAnalysisInfoDto;
import admin.modules.analysis.service.dto.CarAnalysisInfoDto;
import admin.modules.analysis.service.dto.CarAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoDto;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
public interface CarAnalysisInfoService extends CommonService<CarAnalysisInfo>  {

    static final String CACHE_KEY = "carAnalysisInfo";

    /**
    * 查询数据分页
    * @param query 条件
    * @param pageable 分页参数
    * @return PageInfo<CarAnalysisInfoDto>
    */
    PageInfo<CarAnalysisInfoDto> queryAll(CarAnalysisInfoQueryCriteria query, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param query 条件参数
    * @return List<CarAnalysisInfoDto>
    */
    List<CarAnalysisInfoDto> queryAll(CarAnalysisInfoQueryCriteria query);

    CarAnalysisInfo getById(Long id);
    CarAnalysisInfoDto findById(Long id);

    /**
     * 插入一条新数据。
     */
    int insert(CarAnalysisInfoDto resources);
    int updateById(CarAnalysisInfoDto resources);
    int removeById(Long id);
    int removeByIds(Set<Long> ids);

    /**
    * 导出数据
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    // void download(List<CarAnalysisInfoDto> all, HttpServletResponse response) throws IOException;

    PageInfo<CarAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size);
}
