package admin.modules.analysis.service;

import admin.base.CommonService;
import admin.base.PageInfo;
import admin.modules.analysis.domain.DataAnalysisInfo;
import admin.modules.analysis.service.dto.DataAnalysisInfoDto;
import admin.modules.analysis.service.dto.DataAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.dto.DeviceAnalysisInfoDto;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoDto;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
public interface DataAnalysisInfoService extends CommonService<DataAnalysisInfo>  {

    static final String CACHE_KEY = "dataAnalysisInfo";

    /**
    * 查询数据分页
    * @param query 条件
    * @param pageable 分页参数
    * @return PageInfo<DataAnalysisInfoDto>
    */
    PageInfo<DataAnalysisInfoDto> queryAll(DataAnalysisInfoQueryCriteria query, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param query 条件参数
    * @return List<DataAnalysisInfoDto>
    */
    List<DataAnalysisInfoDto> queryAll(DataAnalysisInfoQueryCriteria query);

    DataAnalysisInfo getById(Long id);
    DataAnalysisInfoDto findById(Long id);

    /**
     * 插入一条新数据。
     */
    int insert(DataAnalysisInfoDto resources);
    int updateById(DataAnalysisInfoDto resources);
    int removeById(Long id);
    int removeByIds(Set<Long> ids);

    /**
    * 导出数据
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    // void download(List<DataAnalysisInfoDto> all, HttpServletResponse response) throws IOException;

    PageInfo<DataAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size);
}
