package admin.modules.analysis.service;

import admin.base.CommonService;
import admin.base.PageInfo;
import admin.modules.analysis.domain.DeviceAnalysisInfo;
import admin.modules.analysis.service.dto.DeviceAnalysisInfoDto;
import admin.modules.analysis.service.dto.DeviceAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoDto;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
public interface DeviceAnalysisInfoService extends CommonService<DeviceAnalysisInfo>  {

    static final String CACHE_KEY = "deviceAnalysisInfo";

    /**
    * 查询数据分页
    * @param query 条件
    * @param pageable 分页参数
    * @return PageInfo<DeviceAnalysisInfoDto>
    */
    PageInfo<DeviceAnalysisInfoDto> queryAll(DeviceAnalysisInfoQueryCriteria query, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param query 条件参数
    * @return List<DeviceAnalysisInfoDto>
    */
    List<DeviceAnalysisInfoDto> queryAll(DeviceAnalysisInfoQueryCriteria query);

    DeviceAnalysisInfo getById(Long id);
    DeviceAnalysisInfoDto findById(Long id);

    /**
     * 插入一条新数据。
     */
    int insert(DeviceAnalysisInfoDto resources);
    int updateById(DeviceAnalysisInfoDto resources);
    int removeById(Long id);
    int removeByIds(Set<Long> ids);

    /**
    * 导出数据
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    // void download(List<DeviceAnalysisInfoDto> all, HttpServletResponse response) throws IOException;

    PageInfo<DeviceAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size);
}
