package admin.modules.analysis.service;

import admin.base.CommonService;
import admin.base.PageInfo;
import admin.modules.analysis.domain.MsgAnalysisInfo;
import admin.modules.analysis.service.dto.MsgAnalysisInfoDto;
import admin.modules.analysis.service.dto.MsgAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoDto;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
public interface MsgAnalysisInfoService extends CommonService<MsgAnalysisInfo>  {

    static final String CACHE_KEY = "msgAnalysisInfo";

    /**
    * 查询数据分页
    * @param query 条件
    * @param pageable 分页参数
    * @return PageInfo<MsgAnalysisInfoDto>
    */
    PageInfo<MsgAnalysisInfoDto> queryAll(MsgAnalysisInfoQueryCriteria query, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param query 条件参数
    * @return List<MsgAnalysisInfoDto>
    */
    List<MsgAnalysisInfoDto> queryAll(MsgAnalysisInfoQueryCriteria query);

    MsgAnalysisInfo getById(Long id);
    MsgAnalysisInfoDto findById(Long id);

    /**
     * 插入一条新数据。
     */
    int insert(MsgAnalysisInfoDto resources);
    int updateById(MsgAnalysisInfoDto resources);
    int removeById(Long id);
    int removeByIds(Set<Long> ids);

    /**
    * 导出数据
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    // void download(List<MsgAnalysisInfoDto> all, HttpServletResponse response) throws IOException;

    PageInfo<MsgAnalysisInfoDto>queryPage(String startDate, String endDate, Integer page, Integer size);
}
