package admin.modules.analysis.service;

import admin.base.CommonService;
import admin.base.PageInfo;
import admin.modules.analysis.domain.OrderAnalysisInfo;
import admin.modules.analysis.service.dto.OrderAnalysisInfoDto;
import admin.modules.analysis.service.dto.OrderAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoDto;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
public interface OrderAnalysisInfoService extends CommonService<OrderAnalysisInfo>  {

    static final String CACHE_KEY = "orderAnalysisInfo";

    /**
    * 查询数据分页
    * @param query 条件
    * @param pageable 分页参数
    * @return PageInfo<OrderAnalysisInfoDto>
    */
    PageInfo<OrderAnalysisInfoDto> queryAll(OrderAnalysisInfoQueryCriteria query, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param query 条件参数
    * @return List<OrderAnalysisInfoDto>
    */
    List<OrderAnalysisInfoDto> queryAll(OrderAnalysisInfoQueryCriteria query);

    OrderAnalysisInfo getById(Long id);
    OrderAnalysisInfoDto findById(Long id);

    /**
     * 插入一条新数据。
     */
    int insert(OrderAnalysisInfoDto resources);
    int updateById(OrderAnalysisInfoDto resources);
    int removeById(Long id);
    int removeByIds(Set<Long> ids);

    /**
    * 导出数据
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    // void download(List<OrderAnalysisInfoDto> all, HttpServletResponse response) throws IOException;

    PageInfo<OrderAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size);
}
