package admin.modules.analysis.service;

import admin.base.CommonService;
import admin.base.PageInfo;
import admin.modules.analysis.domain.PayAnalysisInfo;
import admin.modules.analysis.service.dto.PayAnalysisInfoDto;
import admin.modules.analysis.service.dto.PayAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoDto;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
public interface PayAnalysisInfoService extends CommonService<PayAnalysisInfo>  {

    static final String CACHE_KEY = "payAnalysisInfo";

    /**
    * 查询数据分页
    * @param query 条件
    * @param pageable 分页参数
    * @return PageInfo<PayAnalysisInfoDto>
    */
    PageInfo<PayAnalysisInfoDto> queryAll(PayAnalysisInfoQueryCriteria query, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param query 条件参数
    * @return List<PayAnalysisInfoDto>
    */
    List<PayAnalysisInfoDto> queryAll(PayAnalysisInfoQueryCriteria query);

    PayAnalysisInfo getById(Long id);
    PayAnalysisInfoDto findById(Long id);

    /**
     * 插入一条新数据。
     */
    int insert(PayAnalysisInfoDto resources);
    int updateById(PayAnalysisInfoDto resources);
    int removeById(Long id);
    int removeByIds(Set<Long> ids);

    /**
    * 导出数据
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    // void download(List<PayAnalysisInfoDto> all, HttpServletResponse response) throws IOException;

    PageInfo<PayAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size);
}
