package admin.modules.analysis.service;

import admin.base.CommonService;
import admin.base.PageInfo;
import admin.modules.analysis.domain.PlateIdentifyAnalysisInfo;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoDto;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoQueryCriteria;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
public interface PlateIdentifyAnalysisInfoService extends CommonService<PlateIdentifyAnalysisInfo>  {

    static final String CACHE_KEY = "plateIdentifyAnalysisInfo";

    /**
    * 查询数据分页
    * @param query 条件
    * @param pageable 分页参数
    * @return PageInfo<PlateIdentifyAnalysisInfoDto>
    */
    PageInfo<PlateIdentifyAnalysisInfoDto> queryAll(PlateIdentifyAnalysisInfoQueryCriteria query, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param query 条件参数
    * @return List<PlateIdentifyAnalysisInfoDto>
    */
    List<PlateIdentifyAnalysisInfoDto> queryAll(PlateIdentifyAnalysisInfoQueryCriteria query);

    PlateIdentifyAnalysisInfo getById(Long id);
    PlateIdentifyAnalysisInfoDto findById(Long id);

    /**
     * 插入一条新数据。
     */
    int insert(PlateIdentifyAnalysisInfoDto resources);
    int updateById(PlateIdentifyAnalysisInfoDto resources);
    int removeById(Long id);
    int removeByIds(Set<Long> ids);

    PageInfo<PlateIdentifyAnalysisInfoDto> queryPage(String startDate,String endDate,Integer page,Integer size);

    /**
    * 导出数据
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    // void download(List<PlateIdentifyAnalysisInfoDto> all, HttpServletResponse response) throws IOException;
}
