package admin.modules.analysis.service;

import admin.base.CommonService;
import admin.base.PageInfo;
import admin.modules.analysis.domain.PushAnalysisInfo;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoDto;
import admin.modules.analysis.service.dto.PushAnalysisInfoDto;
import admin.modules.analysis.service.dto.PushAnalysisInfoQueryCriteria;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
public interface PushAnalysisInfoService extends CommonService<PushAnalysisInfo>  {

    static final String CACHE_KEY = "pushAnalysisInfo";

    /**
    * 查询数据分页
    * @param query 条件
    * @param pageable 分页参数
    * @return PageInfo<PushAnalysisInfoDto>
    */
    PageInfo<PushAnalysisInfoDto> queryAll(PushAnalysisInfoQueryCriteria query, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param query 条件参数
    * @return List<PushAnalysisInfoDto>
    */
    List<PushAnalysisInfoDto> queryAll(PushAnalysisInfoQueryCriteria query);

    PushAnalysisInfo getById(Long id);
    PushAnalysisInfoDto findById(Long id);

    /**
     * 插入一条新数据。
     */
    int insert(PushAnalysisInfoDto resources);
    int updateById(PushAnalysisInfoDto resources);
    int removeById(Long id);
    int removeByIds(Set<Long> ids);

    /**
    * 导出数据
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    // void download(List<PushAnalysisInfoDto> all, HttpServletResponse response) throws IOException;

    PageInfo<PushAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size);
}
