/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.analysis.service.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @website https://el-admin.vip
* @description /
* @author lj
* @date 2024-12-16
**/
@Data
public class ApiAnalysisInfoDto implements Serializable {

            /** 主键 */
        private Long id;

            /** 日期 */
        private String timeInterval;

            /** 接口访问总量 */
        private BigDecimal totalCount;

            /** 成功访问量 */
        private BigDecimal sucCount;

            /** 失败访问量 */
        private BigDecimal failCount;

            /** 接口平均反应时长 */
        private BigDecimal avgTime;
}
