/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.analysis.service.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @website https://el-admin.vip
* @description /
* @author lj
* @date 2024-12-16
**/
@Data
public class CarAnalysisInfoDto implements Serializable {

            /** 主键 */
                /** 防止精度丢失 */
                @JsonSerialize(using= ToStringSerializer.class)
        private Long id;

            /** 流量预测车辆数 */
        private BigDecimal carPredictNum;

            /** 流量预测准确率 */
        private String carNum;

        private BigDecimal oneInterval;

        private String timeInterval;

        private BigDecimal twoInterval;

        private BigDecimal threeInterval;

        private BigDecimal fourInterval;

        private BigDecimal fiveInterval;

        private BigDecimal sixInterval;

        private BigDecimal sevenInterval;

        private BigDecimal eightInterval;

        private BigDecimal nineInterval;

        private BigDecimal tenInterval;

        private BigDecimal elevenInterval;

        private BigDecimal twelveInterval;
}
