/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.analysis.service.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lj
 * @website https://el-admin.vip
 * @description /
 * @date 2024-12-16
 **/
@Data
public class MsgAnalysisInfoDto implements Serializable {

    /**
     * 主键
     */
    private Long id;

    /**
     * 消息推送数
     */
    private Integer topicCount;
    /**
     * 入场消息数量
     */
    private Integer inNum;
    /**
     * 出场消息数量
     */
    private Integer outNum;
    /**
     * 消息消费数
     */
    private String consumeCount;
    /**
     * 触达率
     */
    private String reachRate;
    /**
     * 日期
     */
    private String timeInterval;
}
