/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.analysis.service.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @website https://el-admin.vip
* @description /
* @author lj
* @date 2024-12-16
**/
@Data
public class PayAnalysisInfoDto implements Serializable {

            /** 主键 */
        private Long id;

            /** 支付消息数 */
        private BigDecimal payMsgNum;

            /** 0-2 */
        private BigDecimal oneInterval;

            /** 日期 */
        private String timeInterval;

            /** 2-4 */
        private BigDecimal twoInterval;

            /** 4-6 */
        private BigDecimal threeInterval;

            /** 6-8 */
        private BigDecimal fourInterval;

            /** 8-10 */
        private BigDecimal fiveInterval;

            /** 10-12 */
        private BigDecimal sixInterval;

            /** 12-14 */
        private BigDecimal sevenInterval;

            /** 14-16 */
        private BigDecimal eightInterval;

            /** 16-18 */
        private BigDecimal nineInterval;

            /** 18-20 */
        private BigDecimal tenInterval;

            /** 20-22 */
        private BigDecimal elevenInterval;

            /** 22-24 */
        private BigDecimal twelveInterval;
}
