/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.analysis.service.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.io.Serializable;

/**
 * @author lj
 * @website https://el-admin.vip
 * @description /
 * @date 2024-12-18
 **/
@Data
public class PushDetailInfoDto implements Serializable {

    /**
     * 防止精度丢失
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 1  入场 2-离场 3 付费  4 离场 5  即将产生费用 100 超时补拍通知
     */
    private Integer msgSubType;

    /**
     * 1-成功 0-失败
     */
    private Integer resulte;

    /**
     * 日期
     */
    private String date;

    /**
     * 消息
     */
    private String content;
}
