package admin.modules.analysis.service.impl;

import admin.base.PageInfo;
import admin.base.QueryHelpMybatisPlus;
import admin.base.impl.CommonServiceImpl;
import admin.modules.analysis.domain.ApiAnalysisInfo;
import admin.modules.analysis.service.ApiAnalysisInfoService;
import admin.modules.analysis.service.dto.ApiAnalysisInfoDto;
import admin.modules.analysis.service.dto.ApiAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.dto.DeviceAnalysisInfoDto;
import admin.modules.analysis.service.mapper.ApiAnalysisInfoMapper;
import admin.utils.ConvertUtil;
import admin.utils.PageUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import lombok.AllArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
@Service
@AllArgsConstructor
// @CacheConfig(cacheNames = ApiAnalysisInfoService.CACHE_KEY)
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class ApiAnalysisInfoServiceImpl extends CommonServiceImpl<ApiAnalysisInfoMapper, ApiAnalysisInfo> implements ApiAnalysisInfoService {

    // private final RedisUtils redisUtils;
    private final ApiAnalysisInfoMapper apiAnalysisInfoMapper;

    @Override
    public PageInfo<ApiAnalysisInfoDto> queryAll(ApiAnalysisInfoQueryCriteria query, Pageable pageable) {
        IPage<ApiAnalysisInfo> queryPage = PageUtil.toMybatisPage(pageable);
        IPage<ApiAnalysisInfo> page = apiAnalysisInfoMapper.selectPage(queryPage, QueryHelpMybatisPlus.getPredicate(query));
        return ConvertUtil.convertPage(page, ApiAnalysisInfoDto.class);
    }

    @Override
    public List<ApiAnalysisInfoDto> queryAll(ApiAnalysisInfoQueryCriteria query){
        return ConvertUtil.convertList(apiAnalysisInfoMapper.selectList(QueryHelpMybatisPlus.getPredicate(query)), ApiAnalysisInfoDto.class);
    }

    @Override
    public ApiAnalysisInfo getById(Long id) {
        return apiAnalysisInfoMapper.selectById(id);
    }

    @Override
    // @Cacheable(key = "'id:' + #p0")
    public ApiAnalysisInfoDto findById(Long id) {
        return ConvertUtil.convert(getById(id), ApiAnalysisInfoDto.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insert(ApiAnalysisInfoDto resources) {
        ApiAnalysisInfo entity = ConvertUtil.convert(resources, ApiAnalysisInfo.class);
        return apiAnalysisInfoMapper.insert(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateById(ApiAnalysisInfoDto resources){
        ApiAnalysisInfo entity = ConvertUtil.convert(resources, ApiAnalysisInfo.class);
        int ret = apiAnalysisInfoMapper.updateById(entity);
        // delCaches(resources.id);
        return ret;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeByIds(Set<Long> ids){
        // delCaches(ids);
        return apiAnalysisInfoMapper.deleteBatchIds(ids);
    }

    @Override
    public ApiAnalysisInfoDto findByTimeInterval(String date) {
        ApiAnalysisInfo analysisInfo = this.lambdaQuery().eq(ApiAnalysisInfo::getTimeInterval, date).one();
        return ConvertUtil.convert(analysisInfo,ApiAnalysisInfoDto.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeById(Long id){
        Set<Long> set = new HashSet<>(1);
        set.add(id);
        return this.removeByIds(set);
    }

    @Override
    public PageInfo<ApiAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size) {
        PageInfo<ApiAnalysisInfoDto> pageInfo = new PageInfo<>();
        Integer count = apiAnalysisInfoMapper.findCount(startDate,endDate);
        List<ApiAnalysisInfoDto> byPage = apiAnalysisInfoMapper.findByPage(startDate, endDate, page * size, size);
        pageInfo.setTotalElements(count);
        pageInfo.setContent(byPage);
        return pageInfo;
    }
    /*
    private void delCaches(Long id) {
        redisUtils.delByKey(CACHE_KEY + "::id:", id);
    }

    private void delCaches(Set<Long> ids) {
        for (Long id: ids) {
            delCaches(id);
        }
    }*/

    /*
    @Override
    public void download(List<ApiAnalysisInfoDto> all, HttpServletResponse response) throws IOException {
      List<Map<String, Object>> list = new ArrayList<>();
      for (ApiAnalysisInfoDto apiAnalysisInfo : all) {
        Map<String,Object> map = new LinkedHashMap<>();
              map.put("日期", apiAnalysisInfo.getTimeInterval());
              map.put("接口访问总量", apiAnalysisInfo.getTotalCount());
              map.put("成功访问量", apiAnalysisInfo.getSucCount());
              map.put("失败访问量", apiAnalysisInfo.getFailCount());
              map.put("接口平均反应时长", apiAnalysisInfo.getAvgTime());
        list.add(map);
      }
      FileUtil.downloadExcel(list, response);
    }*/
}
