package admin.modules.analysis.service.impl;

import admin.base.PageInfo;
import admin.base.QueryHelpMybatisPlus;
import admin.base.impl.CommonServiceImpl;
import admin.modules.analysis.domain.CarAnalysisInfo;
import admin.modules.analysis.service.CarAnalysisInfoService;
import admin.modules.analysis.service.dto.ApiAnalysisInfoDto;
import admin.modules.analysis.service.dto.CarAnalysisInfoDto;
import admin.modules.analysis.service.dto.CarAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.dto.DeviceAnalysisInfoDto;
import admin.modules.analysis.service.mapper.CarAnalysisInfoMapper;
import admin.utils.ConvertUtil;
import admin.utils.PageUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import lombok.AllArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
@Service
@AllArgsConstructor
// @CacheConfig(cacheNames = CarAnalysisInfoService.CACHE_KEY)
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class CarAnalysisInfoServiceImpl extends CommonServiceImpl<CarAnalysisInfoMapper, CarAnalysisInfo> implements CarAnalysisInfoService {

    // private final RedisUtils redisUtils;
    private final CarAnalysisInfoMapper carAnalysisInfoMapper;

    @Override
    public PageInfo<CarAnalysisInfoDto> queryAll(CarAnalysisInfoQueryCriteria query, Pageable pageable) {
        IPage<CarAnalysisInfo> queryPage = PageUtil.toMybatisPage(pageable);
        IPage<CarAnalysisInfo> page = carAnalysisInfoMapper.selectPage(queryPage, QueryHelpMybatisPlus.getPredicate(query));
        return ConvertUtil.convertPage(page, CarAnalysisInfoDto.class);
    }

    @Override
    public List<CarAnalysisInfoDto> queryAll(CarAnalysisInfoQueryCriteria query){
        return ConvertUtil.convertList(carAnalysisInfoMapper.selectList(QueryHelpMybatisPlus.getPredicate(query)), CarAnalysisInfoDto.class);
    }

    @Override
    public CarAnalysisInfo getById(Long id) {
        return carAnalysisInfoMapper.selectById(id);
    }

    @Override
    // @Cacheable(key = "'id:' + #p0")
    public CarAnalysisInfoDto findById(Long id) {
        return ConvertUtil.convert(getById(id), CarAnalysisInfoDto.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insert(CarAnalysisInfoDto resources) {
        CarAnalysisInfo entity = ConvertUtil.convert(resources, CarAnalysisInfo.class);
        return carAnalysisInfoMapper.insert(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateById(CarAnalysisInfoDto resources){
        CarAnalysisInfo entity = ConvertUtil.convert(resources, CarAnalysisInfo.class);
        int ret = carAnalysisInfoMapper.updateById(entity);
        // delCaches(resources.id);
        return ret;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeByIds(Set<Long> ids){
        // delCaches(ids);
        return carAnalysisInfoMapper.deleteBatchIds(ids);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeById(Long id){
        Set<Long> set = new HashSet<>(1);
        set.add(id);
        return this.removeByIds(set);
    }

    @Override
    public PageInfo<CarAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size) {
        PageInfo<CarAnalysisInfoDto> pageInfo = new PageInfo<>();
        Integer count = carAnalysisInfoMapper.findCount(startDate,endDate);
        List<CarAnalysisInfoDto> byPage = carAnalysisInfoMapper.findByPage(startDate, endDate, page * size, size);
        pageInfo.setTotalElements(count);
        pageInfo.setContent(byPage);
        return pageInfo;
    }
    /*
    private void delCaches(Long id) {
        redisUtils.delByKey(CACHE_KEY + "::id:", id);
    }

    private void delCaches(Set<Long> ids) {
        for (Long id: ids) {
            delCaches(id);
        }
    }*/

    /*
    @Override
    public void download(List<CarAnalysisInfoDto> all, HttpServletResponse response) throws IOException {
      List<Map<String, Object>> list = new ArrayList<>();
      for (CarAnalysisInfoDto carAnalysisInfo : all) {
        Map<String,Object> map = new LinkedHashMap<>();
              map.put("流量预测车辆数", carAnalysisInfo.getCarPredictNum());
              map.put("流量预测准确率", carAnalysisInfo.getCarNum());
                map.put(" oneInterval",  carAnalysisInfo.getOneInterval());
                map.put(" timeInterval",  carAnalysisInfo.getTimeInterval());
                map.put(" twoInterval",  carAnalysisInfo.getTwoInterval());
                map.put(" threeInterval",  carAnalysisInfo.getThreeInterval());
                map.put(" fourInterval",  carAnalysisInfo.getFourInterval());
                map.put(" fiveInterval",  carAnalysisInfo.getFiveInterval());
                map.put(" sixInterval",  carAnalysisInfo.getSixInterval());
                map.put(" sevenInterval",  carAnalysisInfo.getSevenInterval());
                map.put(" eightInterval",  carAnalysisInfo.getEightInterval());
                map.put(" nineInterval",  carAnalysisInfo.getNineInterval());
                map.put(" tenInterval",  carAnalysisInfo.getTenInterval());
                map.put(" elevenInterval",  carAnalysisInfo.getElevenInterval());
                map.put(" twelveInterval",  carAnalysisInfo.getTwelveInterval());
        list.add(map);
      }
      FileUtil.downloadExcel(list, response);
    }*/
}
