package admin.modules.analysis.service.impl;

import admin.base.PageInfo;
import admin.base.QueryHelpMybatisPlus;
import admin.base.impl.CommonServiceImpl;
import admin.modules.analysis.domain.DataAnalysisInfo;
import admin.modules.analysis.service.DataAnalysisInfoService;
import admin.modules.analysis.service.dto.CarAnalysisInfoDto;
import admin.modules.analysis.service.dto.DataAnalysisInfoDto;
import admin.modules.analysis.service.dto.DataAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.dto.DeviceAnalysisInfoDto;
import admin.modules.analysis.service.mapper.DataAnalysisInfoMapper;
import admin.utils.ConvertUtil;
import admin.utils.PageUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import lombok.AllArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
@Service
@AllArgsConstructor
// @CacheConfig(cacheNames = DataAnalysisInfoService.CACHE_KEY)
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class DataAnalysisInfoServiceImpl extends CommonServiceImpl<DataAnalysisInfoMapper, DataAnalysisInfo> implements DataAnalysisInfoService {

    // private final RedisUtils redisUtils;
    private final DataAnalysisInfoMapper dataAnalysisInfoMapper;

    @Override
    public PageInfo<DataAnalysisInfoDto> queryAll(DataAnalysisInfoQueryCriteria query, Pageable pageable) {
        IPage<DataAnalysisInfo> queryPage = PageUtil.toMybatisPage(pageable);
        IPage<DataAnalysisInfo> page = dataAnalysisInfoMapper.selectPage(queryPage, QueryHelpMybatisPlus.getPredicate(query));
        return ConvertUtil.convertPage(page, DataAnalysisInfoDto.class);
    }

    @Override
    public List<DataAnalysisInfoDto> queryAll(DataAnalysisInfoQueryCriteria query){
        return ConvertUtil.convertList(dataAnalysisInfoMapper.selectList(QueryHelpMybatisPlus.getPredicate(query)), DataAnalysisInfoDto.class);
    }

    @Override
    public DataAnalysisInfo getById(Long id) {
        return dataAnalysisInfoMapper.selectById(id);
    }

    @Override
    // @Cacheable(key = "'id:' + #p0")
    public DataAnalysisInfoDto findById(Long id) {
        return ConvertUtil.convert(getById(id), DataAnalysisInfoDto.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insert(DataAnalysisInfoDto resources) {
        DataAnalysisInfo entity = ConvertUtil.convert(resources, DataAnalysisInfo.class);
        return dataAnalysisInfoMapper.insert(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateById(DataAnalysisInfoDto resources){
        DataAnalysisInfo entity = ConvertUtil.convert(resources, DataAnalysisInfo.class);
        int ret = dataAnalysisInfoMapper.updateById(entity);
        // delCaches(resources.id);
        return ret;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeByIds(Set<Long> ids){
        // delCaches(ids);
        return dataAnalysisInfoMapper.deleteBatchIds(ids);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeById(Long id){
        Set<Long> set = new HashSet<>(1);
        set.add(id);
        return this.removeByIds(set);
    }

    @Override
    public PageInfo<DataAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size) {
        PageInfo<DataAnalysisInfoDto> pageInfo = new PageInfo<>();
        Integer count = dataAnalysisInfoMapper.findCount(startDate,endDate);
        List<DataAnalysisInfoDto> byPage = dataAnalysisInfoMapper.findByPage(startDate, endDate, page * size, size);
        pageInfo.setTotalElements(count);
        pageInfo.setContent(byPage);
        return pageInfo;
    }

    /*
    private void delCaches(Long id) {
        redisUtils.delByKey(CACHE_KEY + "::id:", id);
    }

    private void delCaches(Set<Long> ids) {
        for (Long id: ids) {
            delCaches(id);
        }
    }*/

    /*
    @Override
    public void download(List<DataAnalysisInfoDto> all, HttpServletResponse response) throws IOException {
      List<Map<String, Object>> list = new ArrayList<>();
      for (DataAnalysisInfoDto dataAnalysisInfo : all) {
        Map<String,Object> map = new LinkedHashMap<>();
              map.put("日存储量", dataAnalysisInfo.getDailyStorageCapacity());
              map.put("图片存储量", dataAnalysisInfo.getImgStorageCapacity());
              map.put("总空间", dataAnalysisInfo.getTotalSpace());
              map.put("剩余空间", dataAnalysisInfo.getRemainingSpace());
              map.put("占用率", dataAnalysisInfo.getUtilizationRatio());
              map.put("日环比", dataAnalysisInfo.getDailyRingRatio());
              map.put("日期", dataAnalysisInfo.getTimeInterval());
        list.add(map);
      }
      FileUtil.downloadExcel(list, response);
    }*/
}
