package admin.modules.analysis.service.impl;

import admin.base.PageInfo;
import admin.base.QueryHelpMybatisPlus;
import admin.base.impl.CommonServiceImpl;
import admin.modules.analysis.domain.DeviceAnalysisInfo;
import admin.modules.analysis.service.DeviceAnalysisInfoService;
import admin.modules.analysis.service.dto.DataAnalysisInfoDto;
import admin.modules.analysis.service.dto.DeviceAnalysisInfoDto;
import admin.modules.analysis.service.dto.DeviceAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.dto.PayAnalysisInfoDto;
import admin.modules.analysis.service.mapper.DeviceAnalysisInfoMapper;
import admin.utils.ConvertUtil;
import admin.utils.PageUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import lombok.AllArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
@Service
@AllArgsConstructor
// @CacheConfig(cacheNames = DeviceAnalysisInfoService.CACHE_KEY)
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class DeviceAnalysisInfoServiceImpl extends CommonServiceImpl<DeviceAnalysisInfoMapper, DeviceAnalysisInfo> implements DeviceAnalysisInfoService {

    // private final RedisUtils redisUtils;
    private final DeviceAnalysisInfoMapper deviceAnalysisInfoMapper;

    @Override
    public PageInfo<DeviceAnalysisInfoDto> queryAll(DeviceAnalysisInfoQueryCriteria query, Pageable pageable) {
        IPage<DeviceAnalysisInfo> queryPage = PageUtil.toMybatisPage(pageable);
        IPage<DeviceAnalysisInfo> page = deviceAnalysisInfoMapper.selectPage(queryPage, QueryHelpMybatisPlus.getPredicate(query));
        return ConvertUtil.convertPage(page, DeviceAnalysisInfoDto.class);
    }

    @Override
    public List<DeviceAnalysisInfoDto> queryAll(DeviceAnalysisInfoQueryCriteria query){
        return ConvertUtil.convertList(deviceAnalysisInfoMapper.selectList(QueryHelpMybatisPlus.getPredicate(query)), DeviceAnalysisInfoDto.class);
    }

    @Override
    public DeviceAnalysisInfo getById(Long id) {
        return deviceAnalysisInfoMapper.selectById(id);
    }

    @Override
    // @Cacheable(key = "'id:' + #p0")
    public DeviceAnalysisInfoDto findById(Long id) {
        return ConvertUtil.convert(getById(id), DeviceAnalysisInfoDto.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insert(DeviceAnalysisInfoDto resources) {
        DeviceAnalysisInfo entity = ConvertUtil.convert(resources, DeviceAnalysisInfo.class);
        return deviceAnalysisInfoMapper.insert(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateById(DeviceAnalysisInfoDto resources){
        DeviceAnalysisInfo entity = ConvertUtil.convert(resources, DeviceAnalysisInfo.class);
        int ret = deviceAnalysisInfoMapper.updateById(entity);
        // delCaches(resources.id);
        return ret;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeByIds(Set<Long> ids){
        // delCaches(ids);
        return deviceAnalysisInfoMapper.deleteBatchIds(ids);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeById(Long id){
        Set<Long> set = new HashSet<>(1);
        set.add(id);
        return this.removeByIds(set);
    }

    @Override
    public PageInfo<DeviceAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size) {
        PageInfo<DeviceAnalysisInfoDto> pageInfo = new PageInfo<>();
        Integer count = deviceAnalysisInfoMapper.findCount(startDate,endDate);
        List<DeviceAnalysisInfoDto> byPage = deviceAnalysisInfoMapper.findByPage(startDate, endDate, page * size, size);
        pageInfo.setTotalElements(count);
        pageInfo.setContent(byPage);
        return pageInfo;
    }
    /*
    private void delCaches(Long id) {
        redisUtils.delByKey(CACHE_KEY + "::id:", id);
    }

    private void delCaches(Set<Long> ids) {
        for (Long id: ids) {
            delCaches(id);
        }
    }*/

    /*
    @Override
    public void download(List<DeviceAnalysisInfoDto> all, HttpServletResponse response) throws IOException {
      List<Map<String, Object>> list = new ArrayList<>();
      for (DeviceAnalysisInfoDto deviceAnalysisInfo : all) {
        Map<String,Object> map = new LinkedHashMap<>();
              map.put("创建时间", deviceAnalysisInfo.getCreateTime());
              map.put("设备类型", deviceAnalysisInfo.getDeviceType());
              map.put("泊位号", deviceAnalysisInfo.getParkingNo());
              map.put("路段id", deviceAnalysisInfo.getRoadId());
              map.put("车场id", deviceAnalysisInfo.getParkingId());
        list.add(map);
      }
      FileUtil.downloadExcel(list, response);
    }*/
}
