package admin.modules.analysis.service.impl;

import admin.base.PageInfo;
import admin.base.QueryHelpMybatisPlus;
import admin.base.impl.CommonServiceImpl;
import admin.modules.analysis.domain.MsgAnalysisInfo;
import admin.modules.analysis.service.MsgAnalysisInfoService;
import admin.modules.analysis.service.dto.DeviceAnalysisInfoDto;
import admin.modules.analysis.service.dto.MsgAnalysisInfoDto;
import admin.modules.analysis.service.dto.MsgAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.dto.PayAnalysisInfoDto;
import admin.modules.analysis.service.mapper.MsgAnalysisInfoMapper;
import admin.utils.ConvertUtil;
import admin.utils.PageUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import lombok.AllArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
@Service
@AllArgsConstructor
// @CacheConfig(cacheNames = MsgAnalysisInfoService.CACHE_KEY)
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class MsgAnalysisInfoServiceImpl extends CommonServiceImpl<MsgAnalysisInfoMapper, MsgAnalysisInfo> implements MsgAnalysisInfoService {

    // private final RedisUtils redisUtils;
    private final MsgAnalysisInfoMapper msgAnalysisInfoMapper;

    @Override
    public PageInfo<MsgAnalysisInfoDto> queryAll(MsgAnalysisInfoQueryCriteria query, Pageable pageable) {
        IPage<MsgAnalysisInfo> queryPage = PageUtil.toMybatisPage(pageable);
        IPage<MsgAnalysisInfo> page = msgAnalysisInfoMapper.selectPage(queryPage, QueryHelpMybatisPlus.getPredicate(query));
        return ConvertUtil.convertPage(page, MsgAnalysisInfoDto.class);
    }

    @Override
    public List<MsgAnalysisInfoDto> queryAll(MsgAnalysisInfoQueryCriteria query){
        return ConvertUtil.convertList(msgAnalysisInfoMapper.selectList(QueryHelpMybatisPlus.getPredicate(query)), MsgAnalysisInfoDto.class);
    }

    @Override
    public MsgAnalysisInfo getById(Long id) {
        return msgAnalysisInfoMapper.selectById(id);
    }

    @Override
    // @Cacheable(key = "'id:' + #p0")
    public MsgAnalysisInfoDto findById(Long id) {
        return ConvertUtil.convert(getById(id), MsgAnalysisInfoDto.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insert(MsgAnalysisInfoDto resources) {
        MsgAnalysisInfo entity = ConvertUtil.convert(resources, MsgAnalysisInfo.class);
        return msgAnalysisInfoMapper.insert(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateById(MsgAnalysisInfoDto resources){
        MsgAnalysisInfo entity = ConvertUtil.convert(resources, MsgAnalysisInfo.class);
        int ret = msgAnalysisInfoMapper.updateById(entity);
        // delCaches(resources.id);
        return ret;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeByIds(Set<Long> ids){
        // delCaches(ids);
        return msgAnalysisInfoMapper.deleteBatchIds(ids);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeById(Long id){
        Set<Long> set = new HashSet<>(1);
        set.add(id);
        return this.removeByIds(set);
    }

    @Override
    public PageInfo<MsgAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size) {
        PageInfo<MsgAnalysisInfoDto> pageInfo = new PageInfo<>();
        Integer count = msgAnalysisInfoMapper.findCount(startDate,endDate);
        List<MsgAnalysisInfoDto> byPage = msgAnalysisInfoMapper.findByPage(startDate, endDate, page * size, size);
        pageInfo.setTotalElements(count);
        pageInfo.setContent(byPage);
        return pageInfo;
    }
    /*
    private void delCaches(Long id) {
        redisUtils.delByKey(CACHE_KEY + "::id:", id);
    }

    private void delCaches(Set<Long> ids) {
        for (Long id: ids) {
            delCaches(id);
        }
    }*/

    /*
    @Override
    public void download(List<MsgAnalysisInfoDto> all, HttpServletResponse response) throws IOException {
      List<Map<String, Object>> list = new ArrayList<>();
      for (MsgAnalysisInfoDto msgAnalysisInfo : all) {
        Map<String,Object> map = new LinkedHashMap<>();
              map.put("消息推送数", msgAnalysisInfo.getPushMsgNum());
              map.put("成功推送数", msgAnalysisInfo.getSucNum());
              map.put("失败推送数", msgAnalysisInfo.getFailNum());
              map.put("成功率", msgAnalysisInfo.getSucRatio());
              map.put("日环比", msgAnalysisInfo.getDailyRingRatio());
              map.put("日期", msgAnalysisInfo.getTimeInterval());
        list.add(map);
      }
      FileUtil.downloadExcel(list, response);
    }*/
}
