package admin.modules.analysis.service.impl;

import admin.base.PageInfo;
import admin.base.QueryHelpMybatisPlus;
import admin.base.impl.CommonServiceImpl;
import admin.modules.analysis.domain.OrderAnalysisInfo;
import admin.modules.analysis.service.OrderAnalysisInfoService;
import admin.modules.analysis.service.dto.MsgAnalysisInfoDto;
import admin.modules.analysis.service.dto.OrderAnalysisInfoDto;
import admin.modules.analysis.service.dto.OrderAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.dto.PayAnalysisInfoDto;
import admin.modules.analysis.service.mapper.OrderAnalysisInfoMapper;
import admin.utils.ConvertUtil;
import admin.utils.PageUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import lombok.AllArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
@Service
@AllArgsConstructor
// @CacheConfig(cacheNames = OrderAnalysisInfoService.CACHE_KEY)
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class OrderAnalysisInfoServiceImpl extends CommonServiceImpl<OrderAnalysisInfoMapper, OrderAnalysisInfo> implements OrderAnalysisInfoService {

    // private final RedisUtils redisUtils;
    private final OrderAnalysisInfoMapper orderAnalysisInfoMapper;

    @Override
    public PageInfo<OrderAnalysisInfoDto> queryAll(OrderAnalysisInfoQueryCriteria query, Pageable pageable) {
        IPage<OrderAnalysisInfo> queryPage = PageUtil.toMybatisPage(pageable);
        IPage<OrderAnalysisInfo> page = orderAnalysisInfoMapper.selectPage(queryPage, QueryHelpMybatisPlus.getPredicate(query));
        return ConvertUtil.convertPage(page, OrderAnalysisInfoDto.class);
    }

    @Override
    public List<OrderAnalysisInfoDto> queryAll(OrderAnalysisInfoQueryCriteria query){
        return ConvertUtil.convertList(orderAnalysisInfoMapper.selectList(QueryHelpMybatisPlus.getPredicate(query)), OrderAnalysisInfoDto.class);
    }

    @Override
    public OrderAnalysisInfo getById(Long id) {
        return orderAnalysisInfoMapper.selectById(id);
    }

    @Override
    // @Cacheable(key = "'id:' + #p0")
    public OrderAnalysisInfoDto findById(Long id) {
        return ConvertUtil.convert(getById(id), OrderAnalysisInfoDto.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insert(OrderAnalysisInfoDto resources) {
        OrderAnalysisInfo entity = ConvertUtil.convert(resources, OrderAnalysisInfo.class);
        return orderAnalysisInfoMapper.insert(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateById(OrderAnalysisInfoDto resources){
        OrderAnalysisInfo entity = ConvertUtil.convert(resources, OrderAnalysisInfo.class);
        int ret = orderAnalysisInfoMapper.updateById(entity);
        // delCaches(resources.id);
        return ret;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeByIds(Set<Long> ids){
        // delCaches(ids);
        return orderAnalysisInfoMapper.deleteBatchIds(ids);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeById(Long id){
        Set<Long> set = new HashSet<>(1);
        set.add(id);
        return this.removeByIds(set);
    }

    @Override
    public PageInfo<OrderAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size) {
        PageInfo<OrderAnalysisInfoDto> pageInfo = new PageInfo<>();
        Integer count = orderAnalysisInfoMapper.findCount(startDate,endDate);
        List<OrderAnalysisInfoDto> byPage = orderAnalysisInfoMapper.findByPage(startDate, endDate, page * size, size);
        pageInfo.setTotalElements(count);
        pageInfo.setContent(byPage);
        return pageInfo;
    }

    /*
    private void delCaches(Long id) {
        redisUtils.delByKey(CACHE_KEY + "::id:", id);
    }

    private void delCaches(Set<Long> ids) {
        for (Long id: ids) {
            delCaches(id);
        }
    }*/

    /*
    @Override
    public void download(List<OrderAnalysisInfoDto> all, HttpServletResponse response) throws IOException {
      List<Map<String, Object>> list = new ArrayList<>();
      for (OrderAnalysisInfoDto orderAnalysisInfo : all) {
        Map<String,Object> map = new LinkedHashMap<>();
              map.put("日期", orderAnalysisInfo.getTimeInterval());
              map.put("云端识别次数", orderAnalysisInfo.getCloudIdentifyNum());
              map.put("云端识别修复次数", orderAnalysisInfo.getCloudIdentifyRepairNum());
              map.put("订单纠正次数", orderAnalysisInfo.getOrderRepairNum());
              map.put("提交人工处理次数", orderAnalysisInfo.getSubmitManualProcessingNum());
              map.put("处理率", orderAnalysisInfo.getProcessingRate());
              map.put("日环比", orderAnalysisInfo.getDailyRingRatio());
        list.add(map);
      }
      FileUtil.downloadExcel(list, response);
    }*/
}
