package admin.modules.analysis.service.impl;

import admin.base.PageInfo;
import admin.base.QueryHelpMybatisPlus;
import admin.base.impl.CommonServiceImpl;
import admin.modules.analysis.domain.PayAnalysisInfo;
import admin.modules.analysis.service.PayAnalysisInfoService;
import admin.modules.analysis.service.dto.OrderAnalysisInfoDto;
import admin.modules.analysis.service.dto.PayAnalysisInfoDto;
import admin.modules.analysis.service.dto.PayAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.dto.PushAnalysisInfoDto;
import admin.modules.analysis.service.mapper.PayAnalysisInfoMapper;
import admin.utils.ConvertUtil;
import admin.utils.PageUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import lombok.AllArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
@Service
@AllArgsConstructor
// @CacheConfig(cacheNames = PayAnalysisInfoService.CACHE_KEY)
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class PayAnalysisInfoServiceImpl extends CommonServiceImpl<PayAnalysisInfoMapper, PayAnalysisInfo> implements PayAnalysisInfoService {

    // private final RedisUtils redisUtils;
    private final PayAnalysisInfoMapper payAnalysisInfoMapper;

    @Override
    public PageInfo<PayAnalysisInfoDto> queryAll(PayAnalysisInfoQueryCriteria query, Pageable pageable) {
        IPage<PayAnalysisInfo> queryPage = PageUtil.toMybatisPage(pageable);
        IPage<PayAnalysisInfo> page = payAnalysisInfoMapper.selectPage(queryPage, QueryHelpMybatisPlus.getPredicate(query));
        return ConvertUtil.convertPage(page, PayAnalysisInfoDto.class);
    }

    @Override
    public List<PayAnalysisInfoDto> queryAll(PayAnalysisInfoQueryCriteria query){
        return ConvertUtil.convertList(payAnalysisInfoMapper.selectList(QueryHelpMybatisPlus.getPredicate(query)), PayAnalysisInfoDto.class);
    }

    @Override
    public PayAnalysisInfo getById(Long id) {
        return payAnalysisInfoMapper.selectById(id);
    }

    @Override
    // @Cacheable(key = "'id:' + #p0")
    public PayAnalysisInfoDto findById(Long id) {
        return ConvertUtil.convert(getById(id), PayAnalysisInfoDto.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insert(PayAnalysisInfoDto resources) {
        PayAnalysisInfo entity = ConvertUtil.convert(resources, PayAnalysisInfo.class);
        return payAnalysisInfoMapper.insert(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateById(PayAnalysisInfoDto resources){
        PayAnalysisInfo entity = ConvertUtil.convert(resources, PayAnalysisInfo.class);
        int ret = payAnalysisInfoMapper.updateById(entity);
        // delCaches(resources.id);
        return ret;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeByIds(Set<Long> ids){
        // delCaches(ids);
        return payAnalysisInfoMapper.deleteBatchIds(ids);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeById(Long id){
        Set<Long> set = new HashSet<>(1);
        set.add(id);
        return this.removeByIds(set);
    }

    @Override
    public PageInfo<PayAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size) {
        PageInfo<PayAnalysisInfoDto> pageInfo = new PageInfo<>();
        Integer count = payAnalysisInfoMapper.findCount(startDate,endDate);
        List<PayAnalysisInfoDto> byPage = payAnalysisInfoMapper.findByPage(startDate, endDate, page * size, size);
        pageInfo.setTotalElements(count);
        pageInfo.setContent(byPage);
        return pageInfo;
    }

    /*
    private void delCaches(Long id) {
        redisUtils.delByKey(CACHE_KEY + "::id:", id);
    }

    private void delCaches(Set<Long> ids) {
        for (Long id: ids) {
            delCaches(id);
        }
    }*/

    /*
    @Override
    public void download(List<PayAnalysisInfoDto> all, HttpServletResponse response) throws IOException {
      List<Map<String, Object>> list = new ArrayList<>();
      for (PayAnalysisInfoDto payAnalysisInfo : all) {
        Map<String,Object> map = new LinkedHashMap<>();
              map.put("支付消息数", payAnalysisInfo.getPayMsgNum());
              map.put("0-2", payAnalysisInfo.getOneInterval());
              map.put("日期", payAnalysisInfo.getTimeInterval());
              map.put("2-4", payAnalysisInfo.getTwoInterval());
              map.put("4-6", payAnalysisInfo.getThreeInterval());
              map.put("6-8", payAnalysisInfo.getFourInterval());
              map.put("8-10", payAnalysisInfo.getFiveInterval());
              map.put("10-12", payAnalysisInfo.getSixInterval());
              map.put("12-14", payAnalysisInfo.getSevenInterval());
              map.put("14-16", payAnalysisInfo.getEightInterval());
              map.put("16-18", payAnalysisInfo.getNineInterval());
              map.put("18-20", payAnalysisInfo.getTenInterval());
              map.put("20-22", payAnalysisInfo.getElevenInterval());
              map.put("22-24", payAnalysisInfo.getTwelveInterval());
        list.add(map);
      }
      FileUtil.downloadExcel(list, response);
    }*/
}
