package admin.modules.analysis.service.impl;

import admin.base.PageInfo;
import admin.base.QueryHelpMybatisPlus;
import admin.base.impl.CommonServiceImpl;
import admin.modules.analysis.domain.PlateIdentifyAnalysisInfo;
import admin.modules.analysis.service.PlateIdentifyAnalysisInfoService;
import admin.modules.analysis.service.dto.PayAnalysisInfoDto;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoDto;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.mapper.PlateIdentifyAnalysisInfoMapper;
import admin.utils.ConvertUtil;
import admin.utils.PageUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import lombok.AllArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
@Service
@AllArgsConstructor
// @CacheConfig(cacheNames = PlateIdentifyAnalysisInfoService.CACHE_KEY)
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class PlateIdentifyAnalysisInfoServiceImpl extends CommonServiceImpl<PlateIdentifyAnalysisInfoMapper, PlateIdentifyAnalysisInfo> implements PlateIdentifyAnalysisInfoService {

    // private final RedisUtils redisUtils;
    private final PlateIdentifyAnalysisInfoMapper plateIdentifyAnalysisInfoMapper;

    @Override
    public PageInfo<PlateIdentifyAnalysisInfoDto> queryAll(PlateIdentifyAnalysisInfoQueryCriteria query, Pageable pageable) {
        IPage<PlateIdentifyAnalysisInfo> queryPage = PageUtil.toMybatisPage(pageable);
        IPage<PlateIdentifyAnalysisInfo> page = plateIdentifyAnalysisInfoMapper.selectPage(queryPage, QueryHelpMybatisPlus.getPredicate(query));
        return ConvertUtil.convertPage(page, PlateIdentifyAnalysisInfoDto.class);
    }

    @Override
    public List<PlateIdentifyAnalysisInfoDto> queryAll(PlateIdentifyAnalysisInfoQueryCriteria query){
        return ConvertUtil.convertList(plateIdentifyAnalysisInfoMapper.selectList(QueryHelpMybatisPlus.getPredicate(query)), PlateIdentifyAnalysisInfoDto.class);
    }

    @Override
    public PlateIdentifyAnalysisInfo getById(Long id) {
        return plateIdentifyAnalysisInfoMapper.selectById(id);
    }

    @Override
    // @Cacheable(key = "'id:' + #p0")
    public PlateIdentifyAnalysisInfoDto findById(Long id) {
        return ConvertUtil.convert(getById(id), PlateIdentifyAnalysisInfoDto.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insert(PlateIdentifyAnalysisInfoDto resources) {
        PlateIdentifyAnalysisInfo entity = ConvertUtil.convert(resources, PlateIdentifyAnalysisInfo.class);
        return plateIdentifyAnalysisInfoMapper.insert(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateById(PlateIdentifyAnalysisInfoDto resources){
        PlateIdentifyAnalysisInfo entity = ConvertUtil.convert(resources, PlateIdentifyAnalysisInfo.class);
        int ret = plateIdentifyAnalysisInfoMapper.updateById(entity);
        // delCaches(resources.id);
        return ret;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeByIds(Set<Long> ids){
        // delCaches(ids);
        return plateIdentifyAnalysisInfoMapper.deleteBatchIds(ids);
    }

    @Override
    public PageInfo<PlateIdentifyAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size) {
        PageInfo<PlateIdentifyAnalysisInfoDto> pageInfo = new PageInfo<>();
        Integer count = plateIdentifyAnalysisInfoMapper.findCount(startDate,endDate);
        List<PlateIdentifyAnalysisInfoDto> byPage = plateIdentifyAnalysisInfoMapper.findByPage(startDate, endDate, page * size, size);
        pageInfo.setTotalElements(count);
        pageInfo.setContent(byPage);
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeById(Long id){
        Set<Long> set = new HashSet<>(1);
        set.add(id);
        return this.removeByIds(set);
    }

    /*
    private void delCaches(Long id) {
        redisUtils.delByKey(CACHE_KEY + "::id:", id);
    }

    private void delCaches(Set<Long> ids) {
        for (Long id: ids) {
            delCaches(id);
        }
    }*/

    /*
    @Override
    public void download(List<PlateIdentifyAnalysisInfoDto> all, HttpServletResponse response) throws IOException {
      List<Map<String, Object>> list = new ArrayList<>();
      for (PlateIdentifyAnalysisInfoDto plateIdentifyAnalysisInfo : all) {
        Map<String,Object> map = new LinkedHashMap<>();
              map.put("日期", plateIdentifyAnalysisInfo.getTimeInterval());
              map.put("车牌识别数", plateIdentifyAnalysisInfo.getPlateIdentifyNum());
              map.put("成功识别数", plateIdentifyAnalysisInfo.getSucIdentifyNum());
              map.put("失败识别次数", plateIdentifyAnalysisInfo.getFailIdentifyNum());
              map.put("成功率", plateIdentifyAnalysisInfo.getSucRatio());
              map.put("日环比", plateIdentifyAnalysisInfo.getDailyRingRatio());
        list.add(map);
      }
      FileUtil.downloadExcel(list, response);
    }*/
}
