package admin.modules.analysis.service.impl;

import admin.base.PageInfo;
import admin.base.QueryHelpMybatisPlus;
import admin.base.impl.CommonServiceImpl;
import admin.modules.analysis.domain.PushAnalysisInfo;
import admin.modules.analysis.service.PushAnalysisInfoService;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoDto;
import admin.modules.analysis.service.dto.PushAnalysisInfoDto;
import admin.modules.analysis.service.dto.PushAnalysisInfoQueryCriteria;
import admin.modules.analysis.service.mapper.PushAnalysisInfoMapper;
import admin.utils.ConvertUtil;
import admin.utils.PageUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import lombok.AllArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
* @author lj
* @date 2024-12-16
*/
@Service
@AllArgsConstructor
// @CacheConfig(cacheNames = PushAnalysisInfoService.CACHE_KEY)
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class PushAnalysisInfoServiceImpl extends CommonServiceImpl<PushAnalysisInfoMapper, PushAnalysisInfo> implements PushAnalysisInfoService {

    // private final RedisUtils redisUtils;
    private final PushAnalysisInfoMapper pushAnalysisInfoMapper;

    @Override
    public PageInfo<PushAnalysisInfoDto> queryAll(PushAnalysisInfoQueryCriteria query, Pageable pageable) {
        IPage<PushAnalysisInfo> queryPage = PageUtil.toMybatisPage(pageable);
        IPage<PushAnalysisInfo> page = pushAnalysisInfoMapper.selectPage(queryPage, QueryHelpMybatisPlus.getPredicate(query));
        return ConvertUtil.convertPage(page, PushAnalysisInfoDto.class);
    }

    @Override
    public List<PushAnalysisInfoDto> queryAll(PushAnalysisInfoQueryCriteria query){
        return ConvertUtil.convertList(pushAnalysisInfoMapper.selectList(QueryHelpMybatisPlus.getPredicate(query)), PushAnalysisInfoDto.class);
    }

    @Override
    public PushAnalysisInfo getById(Long id) {
        return pushAnalysisInfoMapper.selectById(id);
    }

    @Override
    // @Cacheable(key = "'id:' + #p0")
    public PushAnalysisInfoDto findById(Long id) {
        return ConvertUtil.convert(getById(id), PushAnalysisInfoDto.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insert(PushAnalysisInfoDto resources) {
        PushAnalysisInfo entity = ConvertUtil.convert(resources, PushAnalysisInfo.class);
        return pushAnalysisInfoMapper.insert(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateById(PushAnalysisInfoDto resources){
        PushAnalysisInfo entity = ConvertUtil.convert(resources, PushAnalysisInfo.class);
        int ret = pushAnalysisInfoMapper.updateById(entity);
        // delCaches(resources.id);
        return ret;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeByIds(Set<Long> ids){
        // delCaches(ids);
        return pushAnalysisInfoMapper.deleteBatchIds(ids);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int removeById(Long id){
        Set<Long> set = new HashSet<>(1);
        set.add(id);
        return this.removeByIds(set);
    }

    @Override
    public PageInfo<PushAnalysisInfoDto> queryPage(String startDate, String endDate, Integer page, Integer size) {
        PageInfo<PushAnalysisInfoDto> pageInfo = new PageInfo<>();
        Integer count = pushAnalysisInfoMapper.findCount(startDate,endDate);
        List<PushAnalysisInfoDto> byPage = pushAnalysisInfoMapper.findByPage(startDate, endDate, page * size, size);
        pageInfo.setTotalElements(count);
        pageInfo.setContent(byPage);
        return pageInfo;
    }
    /*
    private void delCaches(Long id) {
        redisUtils.delByKey(CACHE_KEY + "::id:", id);
    }

    private void delCaches(Set<Long> ids) {
        for (Long id: ids) {
            delCaches(id);
        }
    }*/

    /*
    @Override
    public void download(List<PushAnalysisInfoDto> all, HttpServletResponse response) throws IOException {
      List<Map<String, Object>> list = new ArrayList<>();
      for (PushAnalysisInfoDto pushAnalysisInfo : all) {
        Map<String,Object> map = new LinkedHashMap<>();
              map.put("消息推送数", pushAnalysisInfo.getPushMsgNum());
              map.put("日期", pushAnalysisInfo.getTimeInterval());
              map.put("成功数", pushAnalysisInfo.getSucNum());
              map.put("失败数", pushAnalysisInfo.getFailNum());
              map.put("成功率", pushAnalysisInfo.getSucRatio());
              map.put("日环比", pushAnalysisInfo.getDailyRingRatio());
        list.add(map);
      }
      FileUtil.downloadExcel(list, response);
    }*/
}
