package admin.modules.analysis.service.mapper;

import admin.annotation.CurDataSource;
import admin.base.CommonMapper;
import admin.modules.analysis.domain.ApiAnalysisInfo;
import admin.modules.analysis.service.dto.ApiAnalysisInfoDto;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
* @author lj
* @date 2024-12-16
*/
@Repository
public interface ApiAnalysisInfoMapper extends CommonMapper<ApiAnalysisInfo> {
    @CurDataSource(value = "slaver")
    List<ApiAnalysisInfoDto> findByPage(@Param("startDate") String startTime,
                                        @Param("endDate") String endTime,
                                        @Param("page") Integer page,
                                        @Param("size") Integer size);
    @CurDataSource(value = "slaver")
    Integer findCount(@Param("startDate") String startTime,
                      @Param("endDate") String endTime);
}
