package admin.modules.analysis.service.mapper;

import admin.annotation.CurDataSource;
import admin.base.CommonMapper;
import admin.modules.analysis.domain.DeviceAnalysisInfo;
import admin.modules.analysis.service.dto.DeviceAnalysisInfoDto;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
* @author lj
* @date 2024-12-16
*/
@Repository
public interface DeviceAnalysisInfoMapper extends CommonMapper<DeviceAnalysisInfo> {
    @CurDataSource(value = "slaver")
    List<DeviceAnalysisInfoDto> findByPage(@Param("startDate") String startTime,
                                           @Param("endDate") String endTime,
                                           @Param("page") Integer page,
                                           @Param("size") Integer size);

    @CurDataSource(value = "slaver")
    Integer findCount(@Param("startDate") String startTime,
                      @Param("endDate") String endTime);
}
