package admin.modules.analysis.service.mapper;

import admin.annotation.CurDataSource;
import admin.base.CommonMapper;
import admin.modules.analysis.domain.MsgAnalysisInfo;
import admin.modules.analysis.service.dto.MsgAnalysisInfoDto;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
* @author lj
* @date 2024-12-16
*/
@Repository
public interface MsgAnalysisInfoMapper extends CommonMapper<MsgAnalysisInfo> {
    @CurDataSource(value = "slaver")
    List<MsgAnalysisInfoDto> findByPage(@Param("startDate") String startTime,
                                        @Param("endDate") String endTime,
                                        @Param("page") Integer page,
                                        @Param("size") Integer size);

    @CurDataSource(value = "slaver")
    Integer findCount(@Param("startDate") String startTime,
                      @Param("endDate") String endTime);
}
