/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.parking.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * @author wl
 * @website https://el-admin.vip
 * @description /
 * @date 2020-10-06
 **/
//@Entity
@Data
//@Table(name="parking_in_info")
@TableName("parking_in_info")
public class ParkingInInfo implements Serializable {

    @Id
    @TableId(value = "parking_in_id", type = IdType.AUTO)
    @ApiModelProperty(value = "parkingInId")
    private Long parkingInId;

    @TableField(value = "secret_key")
    @ApiModelProperty(value = "订单号")
    private String secretKey;

    @TableField(value = "parking_in_serial")
    @ApiModelProperty(value = "车场编号")
    private String parkingInSerial;

    @TableField(value = "parking_in_no")
    @ApiModelProperty(value = "车场id")
    private String parkingInNo;

    @TableField(value = "user_id")
    @ApiModelProperty(value = "用户id")
    private String userId;

    @TableField(value = "user_account")
    @ApiModelProperty(value = "账号")
    private String userAccount;

    @TableField(value = "user_name")
    @ApiModelProperty(value = "用户名称")
    private String userName;

    @TableField(value = "user_password")
    @ApiModelProperty(value = "密码")
    private String userPassword;

    @TableField(value = "charge_rule_desc")
    @ApiModelProperty(value = "收费规则")
    private String chargeRuleDesc;

    @TableField(value = "station_no")
    @ApiModelProperty(value = "终端号")
    private String stationNo;

    @TableField(value = "month_pay_amount")
    @ApiModelProperty(value = "是否允许包月1：允许")
    private BigDecimal monthPayAmount;

    @TableField(value = "can_month_pay")
    @ApiModelProperty(value = "是否允许包月1：允许")
    private Integer canMonthPay;

    @TableField(value = "parking_self")
    @ApiModelProperty(value = "是否自营0：自营，1：非自营")
    private Integer parkingSelf;

    @TableField(value = "in_use")
    @ApiModelProperty(value = "是否使用中：1：使用中")
    private Integer inUse=1;

    @TableField(value = "parking_type")
    @ApiModelProperty(value = "车场类型：1立方车场，2海康车场")
    private Integer parkingType;

    @TableField(value = "total_parking_num")
    @ApiModelProperty(value = "总车位数")
    private Integer totalParkingNum;

    @TableField(value = "use_parking_num")
    @ApiModelProperty(value = "占用车位数")
    private Integer useParkingNum;

    @TableField(value = "channel_id")
    @ApiModelProperty(value = "通道id")
    private String channelId;

    @TableField(value = "latitude")
    @ApiModelProperty(value = "高德坐标")
    private String latitude;

    @TableField(value = "mac_id")
    @ApiModelProperty(value = "商户id")
    private String macId;

    @TableField(value = "mac_key")
    @ApiModelProperty(value = "商户key")
    private String macKey;

    @TableField(value = "longitude")
    @ApiModelProperty(value = "高德坐标")
    private String longitude;

    @TableField(value = "screen_code")
    @ApiModelProperty(value = "屏码")
    private String screenCode;

    @TableField(value = "screen_x")
    @ApiModelProperty(value = "屏宽")
    private Integer screenX;

    @TableField(value = "screen_y")
    @ApiModelProperty(value = "屏高")
    private Integer screenY;

    @TableField(value = "screen_font")
    @ApiModelProperty(value = "字体")
    private Integer screenFont;

    @TableField(value = "create_time")
    @ApiModelProperty(value = "createTime")
    private Timestamp createTime;

    @TableField(value = "tx__latitude")
    @ApiModelProperty(value = "腾讯坐标")
    private String txLatitude;

    @TableField(value = "tx_longitude")
    @ApiModelProperty(value = "腾讯坐标")
    private String txLongitude;

    @TableField(value = "parking_in_name")
    @ApiModelProperty(value = "车场名称")
    private String parkingInName;

    @TableField(value = "parking_in_address")
    @ApiModelProperty(value = "车场详细地址")
    private String parkingInAddress;

    @TableField(value = "parking_in_desc")
    @ApiModelProperty(value = "车场详细描述")
    private String parkingInDesc;

    @TableField(value = "vr_path")
    @ApiModelProperty(value = "车场VR地址")
    private String vrPath;

    @TableField(value = "parent_park")
    @ApiModelProperty(value = "父车场标识")
    private Integer parentPark;

    @TableField(value = "child_key_val")
    @ApiModelProperty(value = "子车场标识")
    private String childKeyVal;

    @TableField(value = "temp_fee_rule")
    @ApiModelProperty(value = "父车场标识")
    private Integer tempFeeRule;

    @TableField(value = "road_id")
    @ApiModelProperty(value = "所属路段id")
    private Long roadId;

    @TableField(value = "road_name")
    @ApiModelProperty(value = "路段名称")
    private String roadName;

    @TableField(value = "parking_domain")
    @ApiModelProperty(value = "域名")
    private String parkingDomain;

    @TableField(value = "park_out_qrcode_1")
    @ApiModelProperty(value = "出场二维码地址")
    private String parkOutQrcode1;

    @TableField(value = "park_out_qrcode_2")
    @ApiModelProperty(value = "出场二维码地址")
    private String parkOutQrcode2;

    @TableField(value = "park_out_qrcode_3")
    @ApiModelProperty(value = "出场二维码地址")
    private String parkOutQrcode3;

    @TableField(value = "park_out_qrcode_4")
    @ApiModelProperty(value = "出场二维码地址")
    private String parkOutQrcode4;

    @TableField(value = "park_temp_in_qrcode_1")
    @ApiModelProperty(value = "入口1的二维码")
    private String parkTempInQrcode1;

    @TableField(value = "park_temp_in_qrcode_2")
    @ApiModelProperty(value = "入口1的二维码")
    private String parkTempInQrcode2;

    @TableField(value = "park_temp_in_qrcode_3")
    @ApiModelProperty(value = "入口1的二维码")
    private String parkTempInQrcode3;

    @TableField(value = "park_temp_in_qrcode_4")
    @ApiModelProperty(value = "入口4的二维码")
    private String parkTempInQrcode4;

    @TableField(value = "park_temp_out_qrcode_1")
    @ApiModelProperty(value = "出口1的二维码")
    private String parkTempOutQrcode1;

    @TableField(value = "park_temp_out_qrcode_2")
    @ApiModelProperty(value = "出口2的二维码")
    private String parkTempOutQrcode2;

    @TableField(value = "park_temp_out_qrcode_3")
    @ApiModelProperty(value = "出口3的二维码")
    private String parkTempOutQrcode3;

    @TableField(value = "park_temp_out_qrcode_4")
    @ApiModelProperty(value = "出口4的二维码")
    private String parkTempOutQrcode4;

    @TableField(value = "park_fee")
    @ApiModelProperty(value = "出口4的二维码")
    private String parkFee;

    @TableField(value = "plan_img")
    @ApiModelProperty(value = "出口4的二维码")
    private String planImg;

    @TableField(value = "pos_json")
    @ApiModelProperty(value = "位置边界")
    private String posJson;

    @TableField(value = "channel_coordinates")
    @ApiModelProperty(value = "位置边界")
    private String channelCoordinates;

    @TableField(value = "is_referrer")
    @ApiModelProperty(value = "是否推荐 0 不推荐 1 推荐")
    private Integer isReferrer;

    @TableField(value = "yun_zong_parking_id")
    @ApiModelProperty(value = "云纵支付车场id")
    private String yunZongParkingId;

    @TableField(value = "park_etc")
    @ApiModelProperty(value = "车场etc是否开通 1 开通")
    private Integer parkEtc;

    @TableField(value = "pay_type")
    @ApiModelProperty(value = "聚合支付类型 1 云纵  2 中科支付")
    private Integer payType;

    @TableField(value = "zk_mch_no")
    @ApiModelProperty(value = "中科商户号")
    private String zkMchNo;

    @TableField(value = "zk_app_id")
    @ApiModelProperty(value = "中科应用id")
    private String zkAppId;

    @TableField(value = "zk_secret_key")
    @ApiModelProperty(value = "商户密钥key")
    private String zkSecretKey;

    @TableField(value = "zk_division_mode")
    @ApiModelProperty(value = "否 分账模式： 0-该笔订单不允许分账[默认], 1-支付成功按配置自动完成分账, 2-商户手动分账(解冻商户金额)")
    private Integer zkDivisionMode;

    @TableField(value = "union_pay_appid")
    @ApiModelProperty(value = "银联支付appid")
    private String unionPayAppid;

    @TableField(value = "show_screen")
    @ApiModelProperty(value = "是否在大屏展示 0：不展示 1：展示")
    private String showScreen;

    @TableField(value = "is_charging")
    @ApiModelProperty(value = "是否带有充电桩  0：仅停车无充电  1：停车充电均有 2：仅充电")
    private Integer isCharging;

    @TableField(value = "is_cst")
    @ApiModelProperty(value = "0-社会停车场 1-城顺通车场")
    private Integer isCst;

    @TableField(value = "charging_num")
    @ApiModelProperty(value = "充电桩数量")
    private Integer chargingNum;

    @TableField(value = "operate_company_id")
    @ApiModelProperty(value = "运营公司id")
    private Long operateCompanyId;

    @TableField(value = "recovery_status")
    @ApiModelProperty(value = "追缴状态 追缴状态：1-开启  0-关闭")
    private Integer recoveryStatus;
    public void copy(ParkingInInfo source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
