/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.parking.domain;

import admin.utils.DateUtil;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * @author wl
 * @website https://el-admin.vip
 * @description /
 * @date 2020-07-12
 **/
//@Entity
@Data
//@Table(name="parking_info")
@TableName("parking_info")
public class ParkingInfo implements Serializable {

    @Id
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
//    @Column(name = "parking_id")
    @TableId(value = "parking_id", type = IdType.AUTO)
    @ApiModelProperty(value = "车位id")
    private Long parkingId;

    //    @Column(name = "parking_serial",nullable = false)
    @TableField(value = "parking_serial")
//    @NotBlank
    @ApiModelProperty(value = "车位编号")
    private String parkingSerial;

    @TableField(value = "parking_name")
    @ApiModelProperty(value = "车位名称")
    private String parkingName;

    //    @Column(name = "road_id")
    @TableField(value = "road_id")
    @ApiModelProperty(value = "路段id")
    private Long roadId;

    @TableField(value = "type")
    @ApiModelProperty(value = "设备类型 1视频桩 2地磁 3巡检车 4 高位")
    private Integer type;

    //    @Column(name = "status")
    @TableField(value = "status")
    @ApiModelProperty(value = "车位状态 1：占用 2：空闲")
    private Integer status = 2;

    //    @Column(name = "job_id")
    @TableField(value = "job_id",updateStrategy = FieldStrategy.IGNORED)
    @ApiModelProperty(value = "岗位id")
    private Long jobId;

    //    @Column(name = "device_id")
    @TableField(value = "device_id")
    @ApiModelProperty(value = "设备id")
    private Long deviceId;

    //    @Column(name = "job_name")
    @TableField(value = "job_name",updateStrategy = FieldStrategy.IGNORED)
    @ApiModelProperty(value = "岗位名称")
    private String jobName;

    //    @Column(name = "road_name")
    @TableField(value = "road_name")
    @ApiModelProperty(value = "路段名称")
    private String roadName;

    //    @Column(name = "device_serial")
    @TableField(value = "device_serial")
    @ApiModelProperty(value = "设备编号")
    private String deviceSerial;

    //    @Column(name = "latitude")
    @TableField(value = "latitude")
    @ApiModelProperty(value = "经纬度")
    private String latitude;

    //    @Column(name = "longitude")
    @TableField(value = "longitude")
    @ApiModelProperty(value = "经纬度")
    private String longitude;

    //    @Column(name = "create_time")
    @TableField(value = "create_time")
    @ApiModelProperty(value = "createTime")
    private Timestamp createTime = DateUtil.getNowTimestamp();

    @TableField(exist = false)
    @ApiModelProperty(value = "车场泊位前缀")
    private String berthPrefix;

    @TableField(exist = false)
    @ApiModelProperty(value = "开始数字")
    private int startNum;

    @TableField(exist = false)
    @ApiModelProperty(value = "结束数字")
    private int endNum;

    public void copy(ParkingInfo source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

    public static boolean checkNum(ParkingInfo source){
        if(ObjectUtil.isEmpty(source.getStartNum())){
            source.setStartNum(0);
        }
        if(ObjectUtil.isEmpty(source.getEndNum())){
            source.setEndNum(0);
        }
        if(source.startNum<0||source.endNum<0||source.startNum> source.endNum){
            return false;
        }
        return true;
    }
}
