/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.parking.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.Id;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * @author wl
 * @website https://el-admin.vip
 * @description /
 * @date 2020-07-12
 **/
//@Entity
@Data
//@Table(name="parking_road_info")
@TableName("parking_road_info")
public class ParkingRoadInfo implements Serializable {

    @Id
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
//    @Column(name = "road_id")
    @TableId(value = "road_id", type = IdType.AUTO)
    @ApiModelProperty(value = "路段id")
    private Long roadId;

    //    @Column(name = "road_name",nullable = false)
    @TableField(value = "road_name")
    @NotBlank
    @ApiModelProperty(value = "路段名称")
    private String roadName;

    @ApiModelProperty(value = "费用规则id")
    @TableField(value = "fee_rule_id")
    private Long feeRuleId;

    @TableField(value = "road_type")
    @ApiModelProperty(value = "路段类型 0：人工，1：地磁，2：高位，3：视频桩")
    private Integer roadType;

    //    @Column(name = "road_serial",nullable = false)
    @TableField(value = "road_serial")
    @NotBlank
    @ApiModelProperty(value = "路段编号")
    private String roadSerial;

    //    @Column(name = "province_id")
    @TableField(value = "province_id")
    @ApiModelProperty(value = "省id")
    private Integer provinceId;

    //    @Column(name = "province_name")
    @TableField(value = "province_name")
    @ApiModelProperty(value = "provinceName")
    private String provinceName;

    //    @Column(name = "city_id")
    @TableField(value = "city_id")
    @ApiModelProperty(value = "cityId")
    private Integer cityId;

    //    @Column(name = "city_name")
    @TableField(value = "city_name")
    @ApiModelProperty(value = "cityName")
    private String cityName;

    //    @Column(name = "area_id")
    @TableField(value = "area_id")
    @ApiModelProperty(value = "areaId")
    private Integer areaId;

    //    @Column(name = "area_name")
    @TableField(value = "area_name")
    @ApiModelProperty(value = "areaName")
    private String areaName;

    //    @Column(name = "address")
    @TableField(value = "address")
    @ApiModelProperty(value = "address")
    private String address;

    //    @Column(name = "latitude")
    @TableField(value = "latitude")
    @ApiModelProperty(value = "latitude")
    private String latitude;

    //    @Column(name = "longitude")
    @TableField(value = "longitude")
    @ApiModelProperty(value = "longitude")
    private String longitude;

    //    @Column(name = "tx_latitude")
    @TableField(value = "tx_latitude")
    @ApiModelProperty(value = "tx_latitude")
    private String txLatitude;

    //    @Column(name = "tx_longitude")
    @TableField(value = "tx_longitude")
    @ApiModelProperty(value = "tx_longitude")
    private String txLongitude;

    @TableField(value = "status")
    @ApiModelProperty(value = "路段状态  1：启用，2：禁用")
    private Integer status=1;

    @TableField(value = "total_parkingnum")
    @ApiModelProperty(value = "路段总车位数")
    private Integer totalParkingnum;

    @TableField(value = "create_time")
    @ApiModelProperty(value = "createTime")
    private Timestamp createTime;

    @TableField(value = "park_fee")
    @ApiModelProperty(value = "出口4的二维码")
    private String parkFee;

    @TableField(value = "plan_img")
    @ApiModelProperty(value = "出口4的二维码")
    private String planImg;

    @TableField(value = "vr_path")
    @ApiModelProperty(value = "VR地址")
    private String vrPath;

    @TableField(value = "pay_type")
    @ApiModelProperty(value = "聚合支付类型 1 云纵  2 中科支付")
    private Integer payType;

    @TableField(value = "zk_mch_no")
    @ApiModelProperty(value = "中科商户号")
    private String zkMchNo;

    @TableField(value = "zk_app_id")
    @ApiModelProperty(value = "中科应用id")
    private String zkAppId;

    @TableField(value = "zk_secret_key")
    @ApiModelProperty(value = "商户密钥key")
    private String zkSecretKey;

    @TableField(value = "zk_division_mode")
    @ApiModelProperty(value = "否 分账模式： 0-该笔订单不允许分账[默认], 1-支付成功按配置自动完成分账, 2-商户手动分账(解冻商户金额)")
    private Integer zkDivisionMode;

    @TableField(value = "show_screen")
    @ApiModelProperty(value = "是否在大屏展示 0：不展示 1：展示")
    private String showScreen;

    @TableField(value = "is_charging")
    @ApiModelProperty(value = "是否带有充电桩  0：仅停车无充电  1：停车充电均有 2：仅充电")
    private Integer isCharging;

    @TableField(value = "charging_num")
    @ApiModelProperty(value = "充电桩数量")
    private Integer chargingNum;

    @TableField(value = "pos_json")
    @ApiModelProperty(value = "位置边界")
    private String posJson;

    public void copy(ParkingRoadInfo source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
