/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.parking.service;

import admin.base.CommonService;
import admin.base.PageInfo;
import admin.modules.parking.domain.ParkingInInfo;
import admin.modules.parking.service.dto.ParkingInInfoDto;
import admin.modules.parking.service.dto.ParkingInInfoQueryCriteria;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
* @website https://el-admin.vip
* @description 服务接口
* @author wl
* @date 2020-10-06
**/
public interface ParkingInInfoService extends CommonService<ParkingInInfo> {


    /**
    * 查询数据分页
    * @param criteria 条件
    * @param pageable 分页参数
    * @return PageInfo<ParkingInInfoDto>
    */
    PageInfo<ParkingInInfoDto> queryAll(ParkingInInfoQueryCriteria criteria, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param criteria 条件参数
    * @return List<ParkingInInfoDto>
    */
    List<ParkingInInfoDto> queryAll(ParkingInInfoQueryCriteria criteria);

    /**
     * 根据ID查询
     * @param parkingInId ID
     * @return ParkingInInfoDto
     */
    ParkingInInfoDto findById(Long parkingInId);

    /**
     * 查询所有车场
     */
    List<ParkingInInfoDto> findAll();

    /**
    * 创建
    * @param resources /
    * @return ParkingInInfoDto
    */
    ParkingInInfoDto create(ParkingInInfo resources);


}
