/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.parking.service;

import admin.base.CommonService;
import admin.base.PageInfo;
import admin.modules.parking.domain.ParkingRoadInfo;
import admin.modules.parking.service.dto.ParkingRoadInfoDto;
import admin.modules.parking.service.dto.ParkingRoadInfoQueryCriteria;
import org.springframework.data.domain.Pageable;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
* @website https://el-admin.vip
* @description 服务接口
* @author wl
* @date 2020-07-12
**/
public interface ParkingRoadInfoService extends CommonService<ParkingRoadInfo> {

    /**
    * 查询数据分页
    * @param criteria 条件
    * @param pageable 分页参数
    * @return PageInfo<ParkingRoadInfoDto>
    */
    PageInfo<ParkingRoadInfoDto> queryAll(ParkingRoadInfoQueryCriteria criteria, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param criteria 条件参数
    * @return List<ParkingRoadInfoDto>
    */
    List<ParkingRoadInfoDto> queryAll(ParkingRoadInfoQueryCriteria criteria);

    /**
     * 根据ID查询
     * @param roadId ID
     * @return ParkingRoadInfoDto
     */
    ParkingRoadInfoDto findById(Long roadId);

    /**
     * 根据路段区域路段编号查询
     * @param areaId
     * @param roadSerial
     * @return
     */
    ParkingRoadInfo findByAreaIdAndRoadSerial(String areaId, String roadSerial);

    /**
    * 创建
    * @param resources /
    * @return ParkingRoadInfoDto
    */
    ParkingRoadInfoDto create(ParkingRoadInfo resources);

    /**
    * 编辑
    * @param resources /
    */
    void update(ParkingRoadInfo resources);

    /**
    * 多选删除
    * @param ids /
    */
    void deleteAll(Long[] ids);

    /**
    * 导出数据
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    void download(List<ParkingRoadInfoDto> all, HttpServletResponse response) throws IOException;

    /**
     * 查找车位数量
     */
    Integer parkingInfoCount(Long roadId,Integer status);

    /**
     * 查询路段所有的信息
     * @return
     */
    List<ParkingRoadInfoDto> getRoadInfo();
}
