/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.parking.service.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;

/**
* @website https://el-admin.vip
* @description /
* @author wl
* @date 2020-10-06
**/
@Data
public class ParkingInInfoDto implements Serializable {

    private Long parkingInId;

    private String parkingInNo;
    /** 车场编号 */
    private String parkingInSerial;
    private Integer parkingType;
    /** 总车位数 */
    private Integer totalParkingNum;
    private String secretKey;
    private Integer parkingSelf;
    private String channelId;
    /** 占用车位数 */
    private Integer useParkingNum;
    /**是否使用中 1：使用中*/
    private Integer inUse=1;
    /** 高德坐标 */
    private String latitude;
    /**临时收费规则id*/
    private Integer tempFeeRule;
    private String vrPath;
    /**父车场标识*/
    private Integer parentPark;
    /**子车场标识*/
    private String childKeyVal;
    /** 高德坐标 */
    private String longitude;

    private String screenCode;
    private Integer screenX;
    private Integer screenY;
    private Integer screenFont;

    private Timestamp createTime;

    /** 腾讯坐标 */
    private String txLatitude;

    /** 腾讯坐标 */
    private String txLongitude;

    /** 车场名称 */
    private String parkingInName;

    /** 车场详细地址 */
    private String parkingInAddress;

    /** 车场详细描述 */
    private String parkingInDesc;

    /** 所属路段id */
    private Long roadId;

    private String macId;
    private String macKey;

    /** 路段名称 */
    private String roadName;
    private String userId;
    private String userAccount;
    private String userName;
    private String userPassword;
    private String chargeRuleDesc;
    private String stationNo;

    private String parkingDomain;

    private String parkOutQrcode1;
    private String parkOutQrcode2;
    private String parkOutQrcode3;
    private String parkOutQrcode4;

    private String parkTempInQrcode1;
    private String parkTempInQrcode2;
    private String parkTempInQrcode3;
    private String parkTempInQrcode4;

    private String parkTempOutQrcode1;
    private String parkTempOutQrcode2;
    private String parkTempOutQrcode3;
    private String parkTempOutQrcode4;
    private String parkFee;
    private String planImg;
    private String posJson;
    private String channelCoordinates;

    private Integer isReferrer;
    private String yunZongParkingId;

    private Integer parkEtc;

    @ApiModelProperty(value = "聚合支付类型 1 云纵  2 中科支付")
    private Integer payType;

    @ApiModelProperty(value = "中科商户号")
    private String zkMchNo;

    @ApiModelProperty(value = "中科应用id")
    private String zkAppId;

    @ApiModelProperty(value = "商户密钥key")
    private String zkSecretKey;

    @ApiModelProperty(value = "否 分账模式： 0-该笔订单不允许分账[默认], 1-支付成功按配置自动完成分账, 2-商户手动分账(解冻商户金额)")
    private Integer zkDivisionMode;
    private String unionPayAppid;

    private String showScreen;

    private Integer isCharging;
    private Integer isCst;

    private Integer chargingNum;

    /**
     * 追缴状态 追缴状态：1-开启  0-关闭
     */
    private Integer recoveryStatus;
}
