/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.parking.service.dto;

import admin.annotation.Query;
import lombok.Data;

import java.sql.Timestamp;
import java.util.List;
import java.util.Set;

/**
* @website https://el-admin.vip
* @author wl
* @date 2020-10-06
**/
@Data
public class ParkingInInfoQueryCriteria{

    @Query
    private Integer canReservation;
    @Query(type = Query.Type.NOT_EQUAL,propName = "parkingSelf")
    private Integer parkingSelfNotEQ;
    @Query
    private Long parkingInId;

    @Query(type = Query.Type.IN,propName = "parkingInId")
    private Set<Long> inParkingInId;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String parkingInSerial;
    @Query
    private Integer parkingType;
    @Query
    private Integer inUse;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String parkingInName;

    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String parkingInAddress;
    @Query
    private Integer parkingSelf;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String parkingInDesc;

    /** 精确 */
    @Query
    private Long roadId;

    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String roadName;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    private List<Timestamp> createTime;
    /** 精确 */
    @Query
    private Integer isReferrer;
}
