/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.parking.service.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;

/**
* @website https://el-admin.vip
* @description /
* @author wl
* @date 2020-07-12
**/
@Data
public class ParkingRoadInfoDto implements Serializable {

    /** 路段id */
    private Long roadId;

    /** 路段名称 */
    private String roadName;
    private Long feeRuleId;

    /** 路段编号 */
    private String roadSerial;
    //路段类型 0：人工，1：地磁，2：高位，3：视频桩
    private Integer roadType;
    /** 省id */
    private Integer provinceId;

    private String provinceName;

    private Integer cityId;

    private String cityName;

    private Integer areaId;

    private String areaName;

    private String address;

    private String latitude;

    private String longitude;

    private String txLatitude;

    private String txLongitude;

    /** 路段状态  1：启用，2：禁用 */
    private Integer status;
    /** 路段总车位数 */
    private Integer totalParkingnum;

    private Timestamp createTime;
    private String parkFee;
    private String planImg;
    private String vrPath;

    private String posJson;

    @ApiModelProperty(value = "聚合支付类型 1 云纵  2 中科支付")
    private Integer payType;

    @ApiModelProperty(value = "中科商户号")
    private String zkMchNo;

    @ApiModelProperty(value = "中科应用id")
    private String zkAppId;

    @ApiModelProperty(value = "商户密钥key")
    private String zkSecretKey;

    @ApiModelProperty(value = "否 分账模式： 0-该笔订单不允许分账[默认], 1-支付成功按配置自动完成分账, 2-商户手动分账(解冻商户金额)")
    private Integer zkDivisionMode;

    private String showScreen;

    private Integer isCharging;

    private Integer chargingNum;
    /**
     * 剩余泊位数
     */
    private Integer remainNum;
}
