/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.parking.service.dto;

import admin.annotation.Query;
import lombok.Data;

/**
* @website https://el-admin.vip
* @author wl
* @date 2020-07-12
**/
@Data
public class ParkingRoadInfoQueryCriteria{

    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String roadName;
    @Query
    private Long feeRuleId;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String roadSerial;
    @Query
    private Integer roadType;
    /** 精确 */
    @Query
    private Integer status;
    /** 精确 */
    @Query
    private Long roadId;
    /** 精确 */
    @Query
    private Integer inUse;
}
