/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.parking.service.impl;

import admin.annotation.CurDataSource;
import admin.base.PageInfo;
import admin.base.QueryHelpMybatisPlus;
import admin.base.impl.CommonServiceImpl;
import admin.modules.parking.domain.ParkingInInfo;
import admin.modules.parking.service.ParkingInInfoService;
import admin.modules.parking.service.dto.ParkingInInfoDto;
import admin.modules.parking.service.dto.ParkingInInfoQueryCriteria;
import admin.modules.parking.service.mapper.ParkingInInfoMapper;
import admin.utils.ConvertUtil;
import admin.utils.PageUtil;
import admin.utils.ValidationUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
* @website https://el-admin.vip
* @description 服务实现
* @author wl
* @date 2020-10-06
**/
@Service
@RequiredArgsConstructor
@Slf4j
@CurDataSource("slaver")
public class ParkingInInfoServiceImpl extends CommonServiceImpl<ParkingInInfoMapper, ParkingInInfo> implements ParkingInInfoService {

    private final ParkingInInfoMapper parkingInInfoMapper;
    @Override
    public PageInfo<ParkingInInfoDto> queryAll(ParkingInInfoQueryCriteria criteria, Pageable pageable){
        IPage<ParkingInInfo> page = PageUtil.toMybatisPage(pageable, false);
        IPage<ParkingInInfo> pageList = parkingInInfoMapper.selectPage(page, QueryHelpMybatisPlus.getPredicate(criteria));
        return ConvertUtil.convertPage(pageList, ParkingInInfoDto.class);
    }

    @Override
    public List<ParkingInInfoDto> queryAll(ParkingInInfoQueryCriteria criteria){
        return ConvertUtil.convertList(parkingInInfoMapper.selectList(QueryHelpMybatisPlus.getPredicate(criteria)), ParkingInInfoDto.class);
    }

    @Override
    @Transactional
    public ParkingInInfoDto findById(Long parkingInId) {
        ParkingInInfo parkingInInfo = parkingInInfoMapper.findById(parkingInId);
        ValidationUtil.isNull(parkingInInfo.getParkingInId(),"ParkingInInfo","parkingInId",parkingInId);
        return ConvertUtil.convert(parkingInInfo, ParkingInInfoDto.class);
    }

    @Override
    public List<ParkingInInfoDto> findAll() {
        List<ParkingInInfo> parkingInInfo = parkingInInfoMapper.findAll();
        return ConvertUtil.convertList(parkingInInfo,ParkingInInfoDto.class);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ParkingInInfoDto create(ParkingInInfo resources) {
        parkingInInfoMapper.insert(resources);
        return ConvertUtil.convert(resources, ParkingInInfoDto.class);
    }


}
