package admin.modules.parking.service.mapper;

import admin.annotation.CurDataSource;
import admin.base.CommonMapper;
import admin.modules.parking.domain.ParkingInInfo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @description: ParkingInInfoMapper
 * @date: 2023/7/24 16:04
 * @author: wk
 * @version: 1.0
 */
@Repository
@CurDataSource("slaver")
public interface ParkingInInfoMapper extends CommonMapper<ParkingInInfo> {
    ParkingInInfo findByParkingInSerial(@Param("parkingInSerial") String parkingInSerial);
    ParkingInInfo findByParentChannel(@Param("parent") Integer parent,
                                      @Param("channelId") String channelId);
    ParkingInInfo findByParkingInNo(@Param("parkingInNo") String parkingInNo);

    Integer parkingCount();

    @CurDataSource(value = "slaver")
    ParkingInInfo findById(@Param("parkingInId") Long parkingInId);

    List<ParkingInInfo> findAll();
}
