package admin.modules.parking.service.mapper;

import admin.annotation.CurDataSource;
import admin.base.CommonMapper;
import admin.modules.parking.domain.ParkingInfo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @description: ParkingInfoMapper
 * @date: 2023/7/24 16:03
 * @author: wk
 * @version: 1.0
 */
@Repository
public interface ParkingInfoMapper extends CommonMapper<ParkingInfo> {

    ParkingInfo findByParkingSerial(@Param("parkingSerial") String parkingSerial);
    @CurDataSource("slaver")
    List<ParkingInfo> findByJobId(@Param("jobId") Long jobId);

    List<ParkingInfo> findByRoadId(@Param("jobId") Long roadId);

    List<Map<String,Object>> getRoadParkingCount(@Param("roadList") Set<Long> roadList);

    Integer getOnlineParkingNum(@Param("status") Integer status);

    List<Map<String,Object>> getParkingUseNum();

    List<ParkingInfo> findByIdIn(@Param("idList") Set<Long> idList);

    void modifyBatchJobMsg(List<Long> list);

    Long findRemainCountByRoadId(Long roadId);
}
