package admin.modules.parking.service.mapper;

import admin.base.CommonMapper;
import admin.modules.parking.domain.ParkingRoadInfo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @description: ParkingRoadInfoMapper
 * @date: 2023/8/11 13:54
 * @author: wk
 * @version: 1.0
 */
@Repository
public interface ParkingRoadInfoMapper extends CommonMapper<ParkingRoadInfo> {

    List<Map<String,Object>> getParkingRoadUseData();

    ParkingRoadInfo findByAreaIdAndRoadSerial(@Param("areaId") String areaId,
                                              @Param("roadSerial") String roadSerial);

    Integer parkingInfoCount(@Param("roadId") Long roadId, @Param("status") Integer status);
}
